/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conmap.ContentMappingService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceAbstract;

@DomainService(nature=NatureOfService.DOMAIN)
@DomainServiceLayout(menuOrder="1000")
public class ContentNegotiationServiceXRoDomainType
extends ContentNegotiationServiceAbstract {
    public static final String X_RO_DOMAIN_TYPE = "x-ro-domain-type";

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAdapter objectAdapter) {
        Object domainObject = this.objectOf(objectAdapter);
        return this.buildResponse(renderContext2, domainObject, RepresentationType.DOMAIN_OBJECT);
    }

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAndActionInvocation objectAndActionInvocation) {
        Object domainObject = this.returnedObjectOf(objectAndActionInvocation);
        return this.buildResponse(renderContext2, domainObject, RepresentationType.ACTION_RESULT);
    }

    protected Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, Object domainObject, RepresentationType representationType) {
        List<MediaType> acceptableMediaTypes = renderContext2.getAcceptableMediaTypes();
        MediaType mediaType = representationType.matchesXmlProfileWithParameter(acceptableMediaTypes, X_RO_DOMAIN_TYPE);
        if (mediaType == null) {
            mediaType = representationType.matchesJsonProfileWithParameter(acceptableMediaTypes, X_RO_DOMAIN_TYPE);
        }
        if (mediaType == null) {
            return null;
        }
        String xRoDomainType = (String)mediaType.getParameters().get(X_RO_DOMAIN_TYPE);
        Class<?> domainType = this.loadClass(xRoDomainType);
        Object mappedDomainObject = this.map(domainObject, acceptableMediaTypes, representationType);
        this.ensureDomainObjectAssignable(xRoDomainType, domainType, mappedDomainObject);
        if ("xml".equals(mediaType.getSubtype())) {
            this.ensureJaxbAnnotated(mappedDomainObject.getClass());
        }
        return Response.ok((Object)mappedDomainObject, (MediaType)mediaType);
    }

    protected Object map(Object domainObject, List<MediaType> acceptableMediaTypes, RepresentationType representationType) {
        Iterable contentMappingServices = this.container.lookupServices(ContentMappingService.class);
        for (ContentMappingService contentMappingService : contentMappingServices) {
            Object mappedObject = contentMappingService.map(domainObject, acceptableMediaTypes, representationType);
            if (mappedObject == null) continue;
            return mappedObject;
        }
        return domainObject;
    }
}

