/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;

public abstract class ContentNegotiationServiceAbstract
implements ContentNegotiationService {
    @Inject
    protected DomainObjectContainer container;

    @Override
    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
    }

    @Override
    @Programmatic
    @PreDestroy
    public void shutdown() {
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAdapter objectAdapter) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAndProperty objectAndProperty) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAndCollection objectAndCollection) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAndAction objectAndAction) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAndActionInvocation objectAndActionInvocation) {
        return null;
    }

    protected Object objectOf(ObjectAdapter objectAdapter) {
        return objectAdapter.getObject();
    }

    protected Object returnedObjectOf(ObjectAndActionInvocation objectAndActionInvocation) {
        ObjectAdapter returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        if (returnedAdapter == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        return this.objectOf(returnedAdapter);
    }

    protected Class<?> loadClass(String cls) {
        Class domainType;
        try {
            domainType = InstanceUtil.loadClass((String)cls);
        }
        catch (Exception ex) {
            throw RestfulObjectsApplicationException.createWithCause(RestfulResponse.HttpStatusCode.BAD_REQUEST, ex);
        }
        return domainType;
    }

    protected void ensureJaxbAnnotated(Class<?> domainType) {
        if (domainType.getAnnotation(XmlRootElement.class) == null) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "Requested domain Type '" + domainType.getName() + "' is not annotated with JAXB @XmlRootElement annotation", new Object[0]);
        }
    }

    protected void ensureDomainObjectAssignable(String xRoDomainType, Class<?> domainType, Object domainObject) {
        if (!domainType.isAssignableFrom(domainObject.getClass())) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE, "Requested object of type '%s' however the object returned by the domain object is not assignable (is '%s')", xRoDomainType, domainObject.getClass().getName());
        }
    }
}

