/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.Responses;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberReprMode;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectActionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectCollectionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;

@DomainService(nature=NatureOfService.DOMAIN)
public class RepresentationServiceForRestfulObjects
implements RepresentationService {
    private static final DateFormat ETAG_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    @Override
    @Programmatic
    public Response objectRepresentation(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter) {
        Response.ResponseBuilder responseBuilder = null;
        if (rendererContext instanceof RepresentationService.Context2) {
            ContentNegotiationService contentNegotiationService;
            RepresentationService.Context2 renderContext2 = (RepresentationService.Context2)rendererContext;
            List<ContentNegotiationService> contentNegotiationServices = this.lookupService(renderContext2, ContentNegotiationService.class);
            Iterator<ContentNegotiationService> iterator = contentNegotiationServices.iterator();
            while (iterator.hasNext() && (responseBuilder = (contentNegotiationService = iterator.next()).buildResponse(renderContext2, objectAdapter)) == null) {
            }
        }
        if (responseBuilder == null) {
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(rendererContext, null, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(objectAdapter).includesSelf();
            responseBuilder = Responses.ofOk(renderer, Caching.NONE);
            Version version = objectAdapter.getVersion();
            if (version != null && version.getTime() != null) {
                responseBuilder.tag(ETAG_FORMAT.format(version.getTime()));
            }
        }
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response propertyDetails(RepresentationService.Context rendererContext, ObjectAndProperty objectAndProperty, MemberReprMode memberReprMode) {
        Response.ResponseBuilder responseBuilder = null;
        if (rendererContext instanceof RepresentationService.Context2) {
            ContentNegotiationService contentNegotiationService;
            RepresentationService.Context2 renderContext2 = (RepresentationService.Context2)rendererContext;
            List<ContentNegotiationService> contentNegotiationServices = this.lookupService(renderContext2, ContentNegotiationService.class);
            Iterator<ContentNegotiationService> iterator = contentNegotiationServices.iterator();
            while (iterator.hasNext() && (responseBuilder = (contentNegotiationService = iterator.next()).buildResponse(renderContext2, objectAndProperty)) == null) {
            }
        }
        if (responseBuilder == null) {
            ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(rendererContext);
            ((ObjectPropertyReprRenderer)((ObjectPropertyReprRenderer)renderer.with(objectAndProperty)).usingLinkTo(rendererContext.getAdapterLinkTo())).withMemberMode(memberReprMode);
            responseBuilder = Responses.ofOk(renderer, Caching.NONE);
        }
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response collectionDetails(RepresentationService.Context rendererContext, ObjectAndCollection objectAndCollection, MemberReprMode memberReprMode) {
        Response.ResponseBuilder responseBuilder = null;
        if (rendererContext instanceof RepresentationService.Context2) {
            ContentNegotiationService contentNegotiationService;
            RepresentationService.Context2 renderContext2 = (RepresentationService.Context2)rendererContext;
            List<ContentNegotiationService> contentNegotiationServices = this.lookupService(renderContext2, ContentNegotiationService.class);
            Iterator<ContentNegotiationService> iterator = contentNegotiationServices.iterator();
            while (iterator.hasNext() && (responseBuilder = (contentNegotiationService = iterator.next()).buildResponse(renderContext2, objectAndCollection)) == null) {
            }
        }
        if (responseBuilder == null) {
            ObjectCollectionReprRenderer renderer = new ObjectCollectionReprRenderer(rendererContext);
            ((ObjectCollectionReprRenderer)((ObjectCollectionReprRenderer)renderer.with(objectAndCollection)).usingLinkTo(rendererContext.getAdapterLinkTo())).withMemberMode(memberReprMode);
            responseBuilder = Responses.ofOk(renderer, Caching.NONE);
        }
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response actionPrompt(RepresentationService.Context rendererContext, ObjectAndAction objectAndAction) {
        Response.ResponseBuilder responseBuilder = null;
        if (rendererContext instanceof RepresentationService.Context2) {
            ContentNegotiationService contentNegotiationService;
            RepresentationService.Context2 renderContext2 = (RepresentationService.Context2)rendererContext;
            List<ContentNegotiationService> contentNegotiationServices = this.lookupService(renderContext2, ContentNegotiationService.class);
            Iterator<ContentNegotiationService> iterator = contentNegotiationServices.iterator();
            while (iterator.hasNext() && (responseBuilder = (contentNegotiationService = iterator.next()).buildResponse(renderContext2, objectAndAction)) == null) {
            }
        }
        if (responseBuilder == null) {
            ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(rendererContext);
            ((ObjectActionReprRenderer)((ObjectActionReprRenderer)renderer.with(objectAndAction)).usingLinkTo(rendererContext.getAdapterLinkTo())).asStandalone();
            responseBuilder = Responses.ofOk(renderer, Caching.NONE);
        }
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response actionResult(RepresentationService.Context rendererContext, ObjectAndActionInvocation objectAndActionInvocation, ActionResultReprRenderer.SelfLink selfLink) {
        Response.ResponseBuilder responseBuilder = null;
        if (rendererContext instanceof RepresentationService.Context2) {
            ContentNegotiationService contentNegotiationService;
            RepresentationService.Context2 renderContext2 = (RepresentationService.Context2)rendererContext;
            List<ContentNegotiationService> contentNegotiationServices = this.lookupService(renderContext2, ContentNegotiationService.class);
            Iterator<ContentNegotiationService> iterator = contentNegotiationServices.iterator();
            while (iterator.hasNext() && (responseBuilder = (contentNegotiationService = iterator.next()).buildResponse(renderContext2, objectAndActionInvocation)) == null) {
            }
        }
        if (responseBuilder == null) {
            ActionResultReprRenderer renderer = new ActionResultReprRenderer(rendererContext, selfLink);
            renderer.with(objectAndActionInvocation).using(rendererContext.getAdapterLinkTo());
            responseBuilder = Responses.ofOk(renderer, Caching.NONE);
            Responses.addLastModifiedAndETagIfAvailable(responseBuilder, objectAndActionInvocation.getObjectAdapter().getVersion());
        }
        return this.buildResponse(responseBuilder);
    }

    protected <T> List<T> lookupService(RepresentationService.Context2 renderContext2, Class<T> serviceClass) {
        return renderContext2.getPersistenceSession().getServicesInjector().lookupServices(serviceClass);
    }

    protected Response buildResponse(Response.ResponseBuilder responseBuilder) {
        return responseBuilder.build();
    }
}

