/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import java.util.Date;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.util.JsonWriterUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public final class Responses {
    private Responses() {
    }

    public static Response.ResponseBuilder ofNoContent() {
        return Responses.of(RestfulResponse.HttpStatusCode.NO_CONTENT);
    }

    public static Response.ResponseBuilder ofOk(ReprRenderer<?, ?> renderer, Caching caching) {
        return Responses.ofOk(renderer, caching, null);
    }

    public static Response.ResponseBuilder ofOk(ReprRenderer<?, ?> renderer, Caching caching, Version version) {
        MediaType mediaType = renderer.getMediaType();
        Response.ResponseBuilder response = Responses.of(RestfulResponse.HttpStatusCode.OK).type(mediaType).cacheControl(caching.getCacheControl()).entity((Object)JsonWriterUtil.jsonFor(renderer.render()));
        return Responses.addLastModifiedAndETagIfAvailable(response, version);
    }

    protected static Response.ResponseBuilder of(RestfulResponse.HttpStatusCode httpStatusCode) {
        return Response.status((Response.StatusType)httpStatusCode.getJaxrsStatusType()).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public static Response.ResponseBuilder addLastModifiedAndETagIfAvailable(Response.ResponseBuilder responseBuilder, Version version) {
        if (version != null && version.getTime() != null) {
            Date time = version.getTime();
            responseBuilder.lastModified(time);
            responseBuilder.tag(Responses.asETag(time));
        }
        return responseBuilder;
    }

    private static EntityTag asETag(Date time) {
        String utcTime = ISODateTimeFormat.basicDateTime().print((ReadableInstant)new DateTime((Object)time));
        return new EntityTag(utcTime, true);
    }
}

