/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.value;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class ValueTypeContractTestAbstract<T> {
    @Before
    public void setUp() throws Exception {
        this.assertSizeAtLeast(this.getObjectsWithSameValue(), 2);
        this.assertSizeAtLeast(this.getObjectsWithDifferentValue(), 1);
    }

    private void assertSizeAtLeast(List<T> objects, int i) {
        Assert.assertThat(objects, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)objects.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(i - 1))));
    }

    @Test
    public void notEqualToNull() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            Assert.assertThat((Object)o1.equals(null), (Matcher)Matchers.is((Object)false));
        }
        for (T o1 : this.getObjectsWithDifferentValue()) {
            Assert.assertThat((Object)o1.equals(null), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void reflexiveAndSymmetric() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            for (T o2 : this.getObjectsWithSameValue()) {
                Assert.assertThat((Object)o1.equals(o2), (Matcher)Matchers.is((Object)true));
                Assert.assertThat((Object)o2.equals(o1), (Matcher)Matchers.is((Object)true));
                Assert.assertThat((Object)o1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)o2.hashCode())));
            }
        }
    }

    @Test
    public void notEqual() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            for (T o2 : this.getObjectsWithDifferentValue()) {
                Assert.assertThat((Object)o1.equals(o2), (Matcher)Matchers.is((Object)false));
                Assert.assertThat((Object)o2.equals(o1), (Matcher)Matchers.is((Object)false));
            }
        }
    }

    @Test
    public void transitiveWhenEqual() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            for (T o2 : this.getObjectsWithSameValue()) {
                for (T o3 : this.getObjectsWithSameValue()) {
                    Assert.assertThat((Object)o1.equals(o2), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)o2.equals(o3), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)o1.equals(o3), (Matcher)Matchers.is((Object)true));
                }
            }
        }
    }

    @Test
    public void comparableEquivalence() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            Comparable c2;
            Assume.assumeThat((Object)(o1 instanceof Comparable), (Matcher)Matchers.is((Object)true));
            Comparable c1 = (Comparable)o1;
            for (T o2 : this.getObjectsWithSameValue()) {
                Assume.assumeThat((Object)(o2 instanceof Comparable), (Matcher)Matchers.is((Object)true));
                c2 = (Comparable)o2;
                Assert.assertThat((Object)c1.compareTo(c2), (Matcher)Matchers.is((Object)0));
                Assert.assertThat((Object)c2.compareTo(c1), (Matcher)Matchers.is((Object)0));
            }
            for (T o2 : this.getObjectsWithDifferentValue()) {
                Assume.assumeThat((Object)(o2 instanceof Comparable), (Matcher)Matchers.is((Object)true));
                c2 = (Comparable)o2;
                int x = c1.compareTo(c2);
                int y = c2.compareTo(c1);
                Assert.assertThat((Object)x, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0)));
                Assert.assertThat((Object)x, (Matcher)Matchers.is((Object)(-y)));
            }
        }
    }

    protected abstract List<T> getObjectsWithSameValue();

    protected abstract List<T> getObjectsWithDifferentValue();
}

