/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;

public class ReflectUtils {
    public static final Predicate<? super Field> persistentMappedBy = new Predicate<Field>(){

        public boolean apply(Field f) {
            Persistent annotation = f.getAnnotation(Persistent.class);
            return annotation != null && !Strings.isNullOrEmpty((String)annotation.mappedBy());
        }
    };

    public static <T> Predicate<Field> withTypeAssignableFrom(final Class<T> type) {
        return new Predicate<Field>(){

            public boolean apply(Field input) {
                return input != null && input.getType().isAssignableFrom(type);
            }
        };
    }

    public static <T> Predicate<Method> withReturnTypeAssignableFrom(final Class<T> type) {
        return new Predicate<Method>(){

            public boolean apply(Method input) {
                return input != null && input.getReturnType().isAssignableFrom(type);
            }
        };
    }

    public static Predicate<Method> withParametersAssignableFrom(final Class<?> ... types) {
        return new Predicate<Method>(){

            public boolean apply(Method input) {
                Class<?>[] parameterTypes;
                if (input != null && (parameterTypes = input.getParameterTypes()).length == types.length) {
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (parameterTypes[i].isAssignableFrom(types[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<? super Method> withEntityParameter() {
        return new Predicate<Method>(){

            public boolean apply(Method m) {
                Class<?> parameterType = m.getParameterTypes()[0];
                return parameterType.isAnnotationPresent(PersistenceCapable.class);
            }
        };
    }
}

