/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.unittestsupport.sortedsets;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import org.apache.isis.core.unittestsupport.AbstractApplyToAllContractTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.reflections.ReflectionUtils;

public abstract class SortedSetsContractTestAbstract
extends AbstractApplyToAllContractTest {
    protected SortedSetsContractTestAbstract(String packagePrefix) {
        super(packagePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applyContractTest(Class<?> entityType) {
        Set collectionFields = ReflectionUtils.getAllFields(entityType, (Predicate[])new Predicate[]{ReflectionUtils.withTypeAssignableTo(Collection.class)});
        for (Field collectionField : collectionFields) {
            try {
                String desc = this.desc(entityType, collectionField);
                this.out.println("processing " + desc);
                this.out.incrementIndent();
                this.process(entityType, collectionField);
            }
            finally {
                this.out.decrementIndent();
            }
        }
    }

    private void process(Class<?> entityType, Field collectionField) {
        Assert.assertThat((String)(this.desc(entityType, collectionField) + " must be a SortedSet"), (Object)ReflectionUtils.withTypeAssignableTo(SortedSet.class).apply((Object)collectionField), (Matcher)CoreMatchers.is((Object)true));
    }

    private String desc(Class<?> entityType, Field collectionField) {
        return entityType.getSimpleName() + "#" + collectionField.getName();
    }
}

