/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.specsupport.scenarios;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.specsupport.scenarios.DomainServiceProvider;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecutionScope;
import org.jmock.Sequence;
import org.jmock.States;
import org.jmock.internal.ExpectationBuilder;

public abstract class ScenarioExecution {
    private static ThreadLocal<ScenarioExecution> current = new ThreadLocal();
    protected final DomainServiceProvider dsp;
    private final ScenarioExecutionScope scope;
    private final Map<VariableId, Object> objectByVariableId = Maps.newLinkedHashMap();
    private final Map<String, Object> objectsById = Maps.newLinkedHashMap();
    private final Map<String, Object> mostRecent = Maps.newHashMap();

    public static ScenarioExecution peek() {
        return current.get();
    }

    public static ScenarioExecution current() {
        ScenarioExecution execution = current.get();
        if (execution == null) {
            throw new IllegalStateException("Scenario has not yet been instantiated");
        }
        return execution;
    }

    protected ScenarioExecution(DomainServiceProvider dsp, ScenarioExecutionScope scope) {
        this.dsp = dsp;
        this.scope = scope;
        current.set(this);
    }

    public boolean ofScope(ScenarioExecutionScope scope) {
        return this.scope == scope;
    }

    public <T> T service(Class<T> cls) {
        T service = this.dsp.getService(cls);
        if (service == null) {
            throw new IllegalStateException("No service of type " + cls.getSimpleName() + " available");
        }
        return service;
    }

    public <T> void replaceService(T original, T replacement) {
        this.dsp.replaceService(original, replacement);
    }

    public DomainObjectContainer container() {
        DomainObjectContainer container = this.dsp.getContainer();
        if (container == null) {
            throw new IllegalStateException("No DomainObjectContainer available");
        }
        return container;
    }

    public WrapperFactory wrapperFactory() {
        return WrapperFactory.NOOP;
    }

    public void putVar(String type, String id, Object value) {
        if (type == null || id == null) {
            throw new IllegalArgumentException("type and id must both be provided to save a scenario variable");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null; use remove() to clear an scenario variable");
        }
        VariableId key = new VariableId(type, id);
        this.objectByVariableId.put(key, value);
        this.objectsById.put(id, value);
        this.mostRecent.put(type, value);
    }

    public void removeVar(String type, String id) {
        if (type != null && id != null) {
            VariableId key = new VariableId(type, id);
            this.objectByVariableId.remove(key);
        }
        if (id != null) {
            this.objectsById.remove(id);
        }
        if (type != null) {
            this.mostRecent.remove(type);
        }
    }

    public Object getVar(String type, String id) {
        if (type != null && id != null) {
            VariableId variableId = new VariableId(type, id);
            Object value = this.objectByVariableId.get(variableId);
            if (value != null) {
                this.mostRecent.put(type, value);
                return value;
            }
            throw new IllegalStateException("No such " + variableId);
        }
        if (type != null && id == null) {
            return this.mostRecent.get(type);
        }
        if (type == null && id != null) {
            Object value = this.objectsById.get(id);
            if (value != null) {
                this.mostRecent.put(type, value);
            }
            return value;
        }
        throw new IllegalArgumentException("Must specify type and/or id");
    }

    public <X> X getVar(String type, String id, Class<X> cls) {
        return (X)this.getVar(type, id);
    }

    public boolean supportsMocks() {
        return false;
    }

    public void checking(ExpectationBuilder expectations) {
        throw new IllegalStateException("Mocks are not supported");
    }

    public void assertIsSatisfied() {
    }

    public Sequence sequence(String name) {
        throw new IllegalStateException("Mocks are not supported");
    }

    public States states(String name) {
        throw new IllegalStateException("Mocks are not supported");
    }

    public void install(InstallableFixture ... fixtures) {
    }

    public void openSession() {
    }

    public void openSession(AuthenticationSession authenticationSession) {
    }

    public void closeSession() {
    }

    public void beginTran() {
    }

    public void endTran(boolean ok) {
    }

    public Object injectServices(Object obj) {
        try {
            Method[] methods;
            for (Method method : methods = obj.getClass().getMethods()) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) continue;
                Class<?> serviceClass = parameterTypes[0];
                if (method.getName().startsWith("inject")) {
                    Object service = this.service(serviceClass);
                    method.invoke(obj, service);
                }
                if (!method.getName().startsWith("set") || serviceClass != DomainObjectContainer.class) continue;
                DomainObjectContainer container = this.container();
                method.invoke(obj, container);
            }
            this.autowireViaFields(obj, obj.getClass());
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void autowireViaFields(Object object, Class<?> cls) {
        List<Field> fields = Arrays.asList(cls.getDeclaredFields());
        Iterable injectFields = Iterables.filter(fields, (Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                Inject annotation = input.getAnnotation(Inject.class);
                return annotation != null;
            }
        });
        for (Field field : injectFields) {
            Object service = this.service(field.getType());
            Class<?> serviceClass = service.getClass();
            field.setAccessible(true);
            ScenarioExecution.invokeInjectorField(field, object, service);
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            this.autowireViaFields(object, superclass);
        }
    }

    private static void invokeInjectorField(Field field, Object target, Object parameter) {
        try {
            field.set(target, parameter);
        }
        catch (IllegalArgumentException e) {
            throw new MetaModelException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MetaModelException(String.format("Cannot access the %s field in %s", field.getName(), target.getClass().getName()));
        }
    }

    public static class VariableId {
        private final String type;
        private final String id;

        public VariableId(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableId other = (VariableId)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "VariableId [type=" + this.type + ", id=" + this.id + "]";
        }
    }
}

