/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.specsupport.scenarios;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.specsupport.scenarios.DomainServiceProvider;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecution;
import org.apache.isis.core.unittestsupport.jmocking.JavassistImposteriser;
import org.hamcrest.Description;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.internal.ExpectationBuilder;

class DomainServiceProviderMockery
implements DomainServiceProvider {
    private DomainObjectContainer mockContainer = null;
    private final Map<Class<?>, Object> mocks = Maps.newHashMap();
    private Mockery context;
    private ScenarioExecution scenarioExecution;

    DomainServiceProviderMockery() {
        this.init();
    }

    private void init() {
        this.context = new Mockery(){
            {
                this.setImposteriser(JavassistImposteriser.INSTANCE);
            }
        };
        this.mocks.clear();
    }

    @Override
    public DomainObjectContainer getContainer() {
        if (this.mockContainer == null) {
            this.mockContainer = this.getService(DomainObjectContainer.class);
            this.context.checking((ExpectationBuilder)new Expectations(){
                {
                    ((DomainObjectContainer)this.allowing(DomainServiceProviderMockery.this.mockContainer)).newTransientInstance((Class)this.with(Expectations.anything()));
                    this.will(new Action(){

                        public Object invoke(Invocation invocation) throws Throwable {
                            Class cls = (Class)invocation.getParameter(0);
                            return DomainServiceProviderMockery.this.scenarioExecution.injectServices(cls.newInstance());
                        }

                        public void describeTo(Description description) {
                            description.appendText("newTransientInstance");
                        }
                    });
                    ((DomainObjectContainer)this.allowing(DomainServiceProviderMockery.this.mockContainer)).persistIfNotAlready(this.with(2.anything()));
                }
            });
        }
        return this.mockContainer;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        Object mock = this.mocks.get(serviceClass);
        if (mock == null) {
            mock = this.context.mock(serviceClass);
        }
        this.mocks.put(serviceClass, mock);
        return (T)mock;
    }

    @Override
    public <T> void replaceService(T original, T replacement) {
        Class<?> originalKey = this.keyFor(original);
        if (originalKey == null) {
            throw new IllegalArgumentException("Service to replace not found");
        }
        this.mocks.put(originalKey, replacement);
    }

    private Class<?> keyFor(Object original) {
        Set<Map.Entry<Class<?>, Object>> entries = this.mocks.entrySet();
        for (Map.Entry<Class<?>, Object> entry : entries) {
            if (entry.getValue() != original) continue;
            return entry.getKey();
        }
        return null;
    }

    public Mockery mockery() {
        return this.context;
    }

    DomainServiceProviderMockery init(ScenarioExecution scenarioExecution) {
        this.scenarioExecution = scenarioExecution;
        return this;
    }

    void assertIsSatisfied() {
        this.mockery().assertIsSatisfied();
        this.init();
    }
}

