/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.security.shiro;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.AuthenticationRequestPassword;
import org.apache.isis.core.runtime.authentication.standard.Authenticator;
import org.apache.isis.core.runtime.authentication.standard.SimpleSession;
import org.apache.isis.core.runtime.authorization.standard.Authorizor;
import org.apache.isis.security.shiro.authorization.IsisPermission;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroAuthenticatorOrAuthorizor
implements Authenticator,
Authorizor {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroAuthenticatorOrAuthorizor.class);
    private final IsisConfiguration configuration;

    public ShiroAuthenticatorOrAuthorizor(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
    }

    protected synchronized RealmSecurityManager getSecurityManager() {
        SecurityManager securityManager;
        try {
            securityManager = SecurityUtils.getSecurityManager();
        }
        catch (UnavailableSecurityManagerException ex) {
            return null;
        }
        if (!(securityManager instanceof RealmSecurityManager)) {
            return null;
        }
        return (RealmSecurityManager)securityManager;
    }

    public void shutdown() {
    }

    public final boolean canAuthenticate(Class<? extends AuthenticationRequest> authenticationRequestClass) {
        if (this.getSecurityManager() == null) {
            return false;
        }
        return AuthenticationRequestPassword.class.isAssignableFrom(authenticationRequestClass);
    }

    public AuthenticationSession authenticate(AuthenticationRequest request, String code) {
        RealmSecurityManager securityManager = this.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        AuthenticationToken token = ShiroAuthenticatorOrAuthorizor.asAuthenticationToken(request);
        Subject currentSubject = SecurityUtils.getSubject();
        if (currentSubject.isAuthenticated()) {
            currentSubject.logout();
        }
        try {
            currentSubject.login(token);
        }
        catch (UnknownAccountException uae) {
            LOG.debug("Unable to authenticate", (Throwable)uae);
            return null;
        }
        catch (IncorrectCredentialsException ice) {
            LOG.debug("Unable to authenticate", (Throwable)ice);
            return null;
        }
        catch (CredentialsException ice) {
            LOG.debug("Unable to authenticate", (Throwable)ice);
            return null;
        }
        catch (LockedAccountException lae) {
            LOG.info("Unable to authenticate", (Throwable)lae);
            return null;
        }
        catch (ExcessiveAttemptsException eae) {
            LOG.info("Unable to authenticate", (Throwable)eae);
            return null;
        }
        catch (AuthenticationException ae) {
            LOG.error("Unable to authenticate", (Throwable)ae);
            return null;
        }
        List<String> roles = this.getRoles(currentSubject, token);
        roles.addAll(request.getRoles());
        return new SimpleSession(request.getName(), roles, code);
    }

    protected List<String> getRoles(Subject subject, AuthenticationToken token) {
        ArrayList roles = Lists.newArrayList();
        RealmSecurityManager securityManager = this.getSecurityManager();
        if (securityManager == null) {
            return roles;
        }
        Set<String> realmNames = ShiroAuthenticatorOrAuthorizor.realmNamesOf(subject);
        Collection realms = securityManager.getRealms();
        for (Realm realm : realms) {
            AuthenticationInfo authenticationInfo;
            if (!realmNames.contains(realm.getName()) || !((authenticationInfo = realm.getAuthenticationInfo(token)) instanceof AuthorizationInfo)) continue;
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)authenticationInfo;
            Collection realmRoles = authorizationInfo.getRoles();
            for (String role : realmRoles) {
                roles.add(realm.getName() + ":" + role);
            }
        }
        return roles;
    }

    private static Set<String> realmNamesOf(Subject subject) {
        PrincipalCollection principals = subject.getPrincipals();
        return principals != null ? principals.getRealmNames() : Collections.emptySet();
    }

    private static AuthenticationToken asAuthenticationToken(AuthenticationRequest request) {
        AuthenticationRequestPassword passwordRequest = (AuthenticationRequestPassword)request;
        String username = passwordRequest.getName();
        String password = passwordRequest.getPassword();
        return new UsernamePasswordToken(username, password);
    }

    public boolean isValid(AuthenticationRequest request) {
        return false;
    }

    public boolean isVisibleInAnyRole(Identifier identifier) {
        return this.isPermitted(identifier, "r");
    }

    public boolean isUsableInAnyRole(Identifier identifier) {
        return this.isPermitted(identifier, "w");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPermitted(Identifier identifier, String qualifier) {
        RealmSecurityManager securityManager = this.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        String permission = ShiroAuthenticatorOrAuthorizor.asPermissionsString(identifier) + ":" + qualifier;
        Subject subject = SecurityUtils.getSubject();
        try {
            boolean bl = subject.isPermitted(permission);
            return bl;
        }
        finally {
            IsisPermission.resetVetoedPermissions();
        }
    }

    private static String asPermissionsString(Identifier identifier) {
        String className;
        String packageName;
        String fullyQualifiedClassName = identifier.getClassName();
        int lastDot = fullyQualifiedClassName.lastIndexOf(46);
        if (lastDot > 0) {
            packageName = fullyQualifiedClassName.substring(0, lastDot);
            className = fullyQualifiedClassName.substring(lastDot + 1);
        } else {
            packageName = "";
            className = fullyQualifiedClassName;
        }
        return packageName + ":" + className + ":" + identifier.getMemberName();
    }

    public boolean isVisibleInRole(String role, Identifier identifier) {
        return false;
    }

    public boolean isUsableInRole(String role, Identifier identifier) {
        return false;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }
}

