/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.security.shiro;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.isis.security.shiro.permrolemapper.PermissionToRoleMapper;
import org.apache.isis.security.shiro.permrolemapper.PermissionToRoleMapperFromIni;
import org.apache.isis.security.shiro.permrolemapper.PermissionToRoleMapperFromString;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.StringUtils;

public class IsisLdapRealm
extends JndiLdapRealm {
    private static final String UNIQUEMEMBER_SUBSTITUTION_TOKEN = "{0}";
    private static final SearchControls SUBTREE_SCOPE = new SearchControls();
    private String searchBase;
    private String groupObjectClass;
    private String uniqueMemberAttribute = "uniqueMember";
    private String uniqueMemberAttributeValuePrefix;
    private String uniqueMemberAttributeValueSuffix;
    protected Set<String> groupExtractedAttribute = Sets.newConcurrentHashSet();
    protected Set<String> userExtractedAttribute = Sets.newConcurrentHashSet();
    protected Set<String> permissionByGroupAttribute = Sets.newConcurrentHashSet();
    protected Set<String> permissionByUserAttribute = Sets.newConcurrentHashSet();
    private String searchUserBase = "";
    private String userObjectClass;
    private final Map<String, String> rolesByGroup = Maps.newLinkedHashMap();
    private PermissionToRoleMapper permissionToRoleMapper;
    private String cnAttribute = "cn";

    public IsisLdapRealm() {
        this.setGroupObjectClass("groupOfUniqueNames");
        this.setUniqueMemberAttribute("uniqueMember");
        this.setUniqueMemberAttributeValueTemplate("uid={0}");
    }

    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        Set<String> roleNames = this.getRoles(principals, ldapContextFactory);
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo(roleNames);
        Set<String> stringPermissions = this.permsFor(roleNames);
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext finalLdapContext = ldapContextFactory.getSystemLdapContext();
        stringPermissions.addAll(this.getPermissionForUser(username, finalLdapContext));
        stringPermissions.addAll(this.getPermissionForRole(username, finalLdapContext));
        simpleAuthorizationInfo.setStringPermissions(stringPermissions);
        return simpleAuthorizationInfo;
    }

    private Set<String> getPermissionForRole(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet permissions = Sets.newLinkedHashSet();
        Set<String> groups = this.groupFor(username, ldapContext);
        NamingEnumeration<SearchResult> searchResultEnum = ldapContext.search(this.searchBase, "objectClass=" + this.groupObjectClass, SUBTREE_SCOPE);
        while (searchResultEnum.hasMore()) {
            SearchResult group = searchResultEnum.next();
            if (!this.memberOf(group, groups)) continue;
            this.addPermIfFound(group, permissions, this.groupExtractedAttribute, this.permissionByGroupAttribute);
        }
        return permissions;
    }

    protected Set<String> groupFor(String userName, LdapContext ldapCtx) throws NamingException {
        LinkedHashSet roleNames = Sets.newLinkedHashSet();
        NamingEnumeration<SearchResult> searchResultEnum = ldapCtx.search(this.searchBase, "objectClass=" + this.groupObjectClass, SUBTREE_SCOPE);
        while (searchResultEnum.hasMore()) {
            SearchResult group = searchResultEnum.next();
            this.addRoleIfMember(userName, group, roleNames);
        }
        return roleNames;
    }

    protected boolean memberOf(SearchResult group, Set<String> groups) throws NamingException {
        Attribute attribute = group.getAttributes().get(this.cnAttribute);
        String groupName = attribute.get().toString();
        return groups.contains(groupName);
    }

    private Collection<String> getPermissionForUser(String username, LdapContext ldapContextFactory) throws NamingException {
        try {
            return this.permUser(username, ldapContextFactory);
        }
        catch (AuthenticationException ex) {
            return Collections.emptySet();
        }
    }

    private Collection<String> permUser(String username, LdapContext systemLdapCtx) throws NamingException {
        LinkedHashSet permissions = Sets.newLinkedHashSet();
        NamingEnumeration<SearchResult> searchResultEnum = systemLdapCtx.search(this.searchUserBase, "objectClass=" + this.userObjectClass, SUBTREE_SCOPE);
        while (searchResultEnum.hasMore()) {
            SearchResult group = searchResultEnum.next();
            this.addPermIfFound(group, permissions, this.userExtractedAttribute, this.permissionByUserAttribute);
        }
        return permissions;
    }

    private void addPermIfFound(SearchResult group, Set<String> permissions, Set<String> extractedAttributeP, Set<String> permissionByAttributeP) throws NamingException {
        NamingEnumeration<? extends Attribute> attributeEnum = group.getAttributes().getAll();
        HashMap keyValues = Maps.newHashMap();
        while (attributeEnum.hasMore()) {
            Attribute attr = attributeEnum.next();
            if (!extractedAttributeP.contains(attr.getID())) continue;
            NamingEnumeration<?> e = attr.getAll();
            keyValues.put(attr.getID(), new HashSet());
            while (e.hasMore()) {
                String attrValue = e.next().toString();
                ((Set)keyValues.get(attr.getID())).add(attrValue);
            }
        }
        for (String permTempl : permissionByAttributeP) {
            for (String key : keyValues.keySet()) {
                if (!permTempl.contains("{" + key + "}")) continue;
                for (String value : (Set)keyValues.get(key)) {
                    permissions.add(permTempl.replaceAll("\\{" + key + "\\}", value));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRoles(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext systemLdapCtx = null;
        try {
            systemLdapCtx = ldapContextFactory.getSystemLdapContext();
            Set<String> set = this.rolesFor(username, systemLdapCtx);
            return set;
        }
        catch (javax.naming.AuthenticationException ex) {
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            LdapUtils.closeContext((LdapContext)systemLdapCtx);
        }
    }

    private Set<String> rolesFor(String userName, LdapContext ldapCtx) throws NamingException {
        LinkedHashSet roleNames = Sets.newLinkedHashSet();
        NamingEnumeration<SearchResult> searchResultEnum = ldapCtx.search(this.searchBase, "objectClass=" + this.groupObjectClass, SUBTREE_SCOPE);
        while (searchResultEnum.hasMore()) {
            SearchResult group = searchResultEnum.next();
            this.addRoleIfMember(userName, group, roleNames);
        }
        return roleNames;
    }

    private void addRoleIfMember(String userName, SearchResult group, Set<String> roleNames) throws NamingException {
        NamingEnumeration<? extends Attribute> attributeEnum = group.getAttributes().getAll();
        block0: while (attributeEnum.hasMore()) {
            Attribute attr = attributeEnum.next();
            if (!this.uniqueMemberAttribute.equalsIgnoreCase(attr.getID())) continue;
            NamingEnumeration<?> e = attr.getAll();
            while (e.hasMore()) {
                String attrValue = e.next().toString();
                if (!(this.uniqueMemberAttributeValuePrefix + userName + this.uniqueMemberAttributeValueSuffix).equals(attrValue)) continue;
                Attribute attribute = group.getAttributes().get("cn");
                String groupName = attribute.get().toString();
                String roleName = this.roleNameFor(groupName);
                if (roleName == null) continue block0;
                roleNames.add(roleName);
                continue block0;
            }
        }
    }

    private String roleNameFor(String groupName) {
        return !this.rolesByGroup.isEmpty() ? this.rolesByGroup.get(groupName) : groupName;
    }

    private Set<String> permsFor(Set<String> roleNames) {
        LinkedHashSet perms = Sets.newLinkedHashSet();
        for (String role : roleNames) {
            List<String> permsForRole = this.getPermissionsByRole().get(role);
            if (permsForRole == null) continue;
            perms.addAll(permsForRole);
        }
        return perms;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setGroupObjectClass(String groupObjectClassAttribute) {
        this.groupObjectClass = groupObjectClassAttribute;
    }

    public void setUniqueMemberAttribute(String uniqueMemberAttribute) {
        this.uniqueMemberAttribute = uniqueMemberAttribute;
    }

    public void setUniqueMemberAttributeValueTemplate(String template) {
        if (!StringUtils.hasText((String)template)) {
            String msg = "User DN template cannot be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        int index = template.indexOf(UNIQUEMEMBER_SUBSTITUTION_TOKEN);
        if (index < 0) {
            String msg = "UniqueMember attribute value template must contain the '{0}' replacement token to understand how to parse the group members.";
            throw new IllegalArgumentException(msg);
        }
        String prefix = template.substring(0, index);
        String suffix = template.substring(prefix.length() + UNIQUEMEMBER_SUBSTITUTION_TOKEN.length());
        this.uniqueMemberAttributeValuePrefix = prefix;
        this.uniqueMemberAttributeValueSuffix = suffix;
    }

    public void setRolesByGroup(Map<String, String> rolesByGroup) {
        this.rolesByGroup.putAll(rolesByGroup);
    }

    private Map<String, List<String>> getPermissionsByRole() {
        if (this.permissionToRoleMapper == null) {
            throw new IllegalStateException("Permissions by role not yet set.");
        }
        return this.permissionToRoleMapper.getPermissionsByRole();
    }

    public void setResourcePath(String resourcePath) {
        if (this.permissionToRoleMapper != null) {
            throw new IllegalStateException("Permissions already set, " + this.permissionToRoleMapper.getClass().getName());
        }
        Ini ini = Ini.fromResourcePath((String)resourcePath);
        this.permissionToRoleMapper = new PermissionToRoleMapperFromIni(ini);
    }

    @Deprecated
    public void setPermissionsByRole(String permissionsByRoleStr) {
        if (this.permissionToRoleMapper != null) {
            throw new IllegalStateException("Permissions already set, " + this.permissionToRoleMapper.getClass().getName());
        }
        this.permissionToRoleMapper = new PermissionToRoleMapperFromString(permissionsByRoleStr);
    }

    public void setPermissionByUserAttribute(String permissionByUserAttr) {
        Object[] list = permissionByUserAttr.split(",");
        this.permissionByUserAttribute.addAll(Lists.newArrayList((Object[])list));
    }

    public void setPermissionByGroupAttribute(String permissionByGroupAttribute) {
        Object[] list = permissionByGroupAttribute.split(",");
        this.permissionByGroupAttribute.addAll(Lists.newArrayList((Object[])list));
    }

    public void setUserExtractedAttribute(String userExtractedAttribute) {
        Object[] list = userExtractedAttribute.split(",");
        this.userExtractedAttribute.addAll(Lists.newArrayList((Object[])list));
    }

    public void setGroupExtractedAttribute(String groupExtractedAttribute) {
        Object[] list = groupExtractedAttribute.split(",");
        this.groupExtractedAttribute.addAll(Lists.newArrayList((Object[])list));
    }

    public void setSearchUserBase(String searchUserBase) {
        this.searchUserBase = searchUserBase;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public void setCnAttribute(String cnAttribute) {
        this.cnAttribute = cnAttribute;
    }

    static {
        SUBTREE_SCOPE.setSearchScope(2);
    }
}

