/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.metadata.TypeMetadata;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusObjectStore;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.FrameworkSynchronizer;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessor;
import org.datanucleus.enhancement.Persistable;

public abstract class PersistenceQueryProcessorAbstract<T extends PersistenceQuery>
implements PersistenceQueryProcessor<T> {
    private final PersistenceManager persistenceManager;
    private final FrameworkSynchronizer frameworkSynchronizer;

    protected PersistenceQueryProcessorAbstract(PersistenceManager persistenceManager, FrameworkSynchronizer frameworkSynchronizer) {
        this.persistenceManager = persistenceManager;
        this.frameworkSynchronizer = frameworkSynchronizer;
    }

    protected PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    protected PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.getPersistenceManager().getPersistenceManagerFactory();
    }

    protected TypeMetadata getTypeMetadata(String classFullName) {
        return this.getPersistenceManagerFactory().getMetadata(classFullName);
    }

    protected List<ObjectAdapter> loadAdapters(ObjectSpecification specification, List<?> pojos) {
        ArrayList adapters = Lists.newArrayList();
        for (Object pojo : pojos) {
            ObjectAdapter adapter;
            if (pojo instanceof Persistable) {
                this.frameworkSynchronizer.postLoadProcessingFor((Persistable)pojo, FrameworkSynchronizer.CalledFrom.OS_QUERY);
                adapter = this.getAdapterManager().getAdapterFor(pojo);
            } else {
                adapter = this.getAdapterManager().adapterFor(pojo);
            }
            Assert.assertNotNull((Object)adapter);
            adapters.add(adapter);
        }
        return adapters;
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    protected DataNucleusObjectStore getJdoObjectStore() {
        return (DataNucleusObjectStore)IsisContext.getPersistenceSession().getObjectStore();
    }
}

