/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence;

import javax.jdo.listener.InstanceLifecycleEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.SerialNumberVersion;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.datanucleus.enhancement.Persistable;

public class Utils {
    private static Object jdoObjectIdFor(InstanceLifecycleEvent event) {
        Persistable persistenceCapable = Utils.persistenceCapableFor(event);
        Object jdoObjectId = persistenceCapable.dnGetObjectId();
        return jdoObjectId;
    }

    static Persistable persistenceCapableFor(InstanceLifecycleEvent event) {
        return (Persistable)event.getSource();
    }

    static void clearDirtyFor(ObjectAdapter adapter) {
        adapter.getSpecification().clearDirty(adapter);
    }

    static Version getVersionIfAny(Persistable pojo, AuthenticationSession authenticationSession) {
        Object jdoVersion = pojo.dnGetVersion();
        if (jdoVersion instanceof Long) {
            return SerialNumberVersion.create((long)((Long)jdoVersion), (String)authenticationSession.getUserName(), null);
        }
        return null;
    }
}

