/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.jdo.listener.AttachLifecycleListener;
import javax.jdo.listener.ClearLifecycleListener;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.DetachLifecycleListener;
import javax.jdo.listener.DirtyLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.LoadLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.FrameworkSynchronizer;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.LoggingLocation;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.SuspendableListener;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.Utils;
import org.datanucleus.enhancement.Persistable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisLifecycleListener
implements AttachLifecycleListener,
ClearLifecycleListener,
CreateLifecycleListener,
DeleteLifecycleListener,
DetachLifecycleListener,
DirtyLifecycleListener,
LoadLifecycleListener,
StoreLifecycleListener,
SuspendableListener {
    private static final Logger LOG = LoggerFactory.getLogger(IsisLifecycleListener.class);
    private final FrameworkSynchronizer synchronizer;
    private boolean suspended;
    private static Map<Integer, LifecycleEventType> events = Maps.newHashMap();

    public IsisLifecycleListener(FrameworkSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void postCreate(InstanceLifecycleEvent event) {
        this.withLogging(Phase.POST, event, new RunnableNoop(event));
    }

    public void preAttach(InstanceLifecycleEvent event) {
        this.withLogging(Phase.PRE, event, new RunnableEnsureFrameworksInAgreement(event));
    }

    public void postAttach(InstanceLifecycleEvent event) {
        this.withLogging(Phase.POST, event, new RunnableEnsureFrameworksInAgreement(event));
    }

    public void postLoad(InstanceLifecycleEvent event) {
        this.withLogging(Phase.POST, event, new RunnableAbstract(event){

            @Override
            protected void doRun() {
                Persistable pojo = Utils.persistenceCapableFor(this.event);
                IsisLifecycleListener.this.synchronizer.postLoadProcessingFor(pojo, FrameworkSynchronizer.CalledFrom.EVENT_LOAD);
            }
        });
    }

    public void preStore(InstanceLifecycleEvent event) {
        this.withLogging(Phase.PRE, event, new RunnableAbstract(event){

            @Override
            protected void doRun() {
                Persistable pojo = Utils.persistenceCapableFor(this.event);
                IsisLifecycleListener.this.synchronizer.preStoreProcessingFor(pojo, FrameworkSynchronizer.CalledFrom.EVENT_PRESTORE);
            }
        });
    }

    public void postStore(InstanceLifecycleEvent event) {
        this.withLogging(Phase.POST, event, new RunnableAbstract(event){

            @Override
            protected void doRun() {
                Persistable pojo = Utils.persistenceCapableFor(this.event);
                IsisLifecycleListener.this.synchronizer.postStoreProcessingFor(pojo, FrameworkSynchronizer.CalledFrom.EVENT_POSTSTORE);
            }
        });
    }

    public void preDirty(InstanceLifecycleEvent event) {
        this.withLogging(Phase.PRE, event, new RunnableAbstract(event){

            @Override
            protected void doRun() {
                Persistable pojo = Utils.persistenceCapableFor(this.event);
                IsisLifecycleListener.this.synchronizer.preDirtyProcessingFor(pojo, FrameworkSynchronizer.CalledFrom.EVENT_PREDIRTY);
            }
        });
    }

    public void postDirty(InstanceLifecycleEvent event) {
        this.withLogging(Phase.POST, event, new RunnableNoop(event));
    }

    public void preDelete(InstanceLifecycleEvent event) {
        this.withLogging(Phase.PRE, event, new RunnableAbstract(event){

            @Override
            protected void doRun() {
                Persistable pojo = Utils.persistenceCapableFor(this.event);
                IsisLifecycleListener.this.synchronizer.preDeleteProcessingFor(pojo, FrameworkSynchronizer.CalledFrom.EVENT_PREDELETE);
            }
        });
    }

    public void postDelete(InstanceLifecycleEvent event) {
        this.withLogging(Phase.POST, event, new RunnableAbstract(event){

            @Override
            protected void doRun() {
                Persistable pojo = Utils.persistenceCapableFor(this.event);
                IsisLifecycleListener.this.synchronizer.postDeleteProcessingFor(pojo, FrameworkSynchronizer.CalledFrom.EVENT_POSTDELETE);
            }
        });
    }

    public void preClear(InstanceLifecycleEvent event) {
    }

    public void postClear(InstanceLifecycleEvent event) {
    }

    public void preDetach(InstanceLifecycleEvent event) {
        this.withLogging(Phase.PRE, event, new RunnableEnsureFrameworksInAgreement(event));
    }

    public void postDetach(InstanceLifecycleEvent event) {
        this.withLogging(Phase.POST, event, new RunnableEnsureFrameworksInAgreement(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withLogging(Phase phase, InstanceLifecycleEvent event, Runnable runnable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.logString(phase, LoggingLocation.ENTRY, event));
        }
        try {
            runnable.run();
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.logString(phase, LoggingLocation.EXIT, event));
            }
        }
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    private String logString(Phase phase, LoggingLocation location, InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        AdapterManager adapterManager = this.getAdapterManager();
        ObjectAdapter adapter = adapterManager.getAdapterFor((Object)pojo);
        return (Object)((Object)phase) + " " + location.prefix + " " + (Object)((Object)LifecycleEventType.lookup(event.getEventType())) + ": oid=" + (adapter != null ? adapter.getOid() : "(null)") + " ,pojo " + pojo;
    }

    protected AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    private static enum LifecycleEventType {
        CREATE(0),
        LOAD(1),
        STORE(2),
        CLEAR(3),
        DELETE(4),
        DIRTY(5),
        DETACH(6),
        ATTACH(7);


        private LifecycleEventType(int code) {
            events.put(code, this);
        }

        public static LifecycleEventType lookup(int code) {
            return (LifecycleEventType)((Object)events.get(code));
        }
    }

    private static enum Phase {
        PRE,
        POST;

    }

    private class RunnableEnsureFrameworksInAgreement
    extends RunnableAbstract {
        RunnableEnsureFrameworksInAgreement(InstanceLifecycleEvent event) {
            super(event);
        }

        @Override
        protected void doRun() {
            Persistable pojo = Utils.persistenceCapableFor(this.event);
            IsisLifecycleListener.this.synchronizer.ensureRootObject(pojo);
            IsisLifecycleListener.this.synchronizer.ensureFrameworksInAgreement(pojo);
        }
    }

    private class RunnableNoop
    extends RunnableAbstract {
        RunnableNoop(InstanceLifecycleEvent event) {
            super(event);
        }

        @Override
        protected void doRun() {
        }
    }

    private abstract class RunnableAbstract
    implements Runnable {
        final InstanceLifecycleEvent event;

        public RunnableAbstract(InstanceLifecycleEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (IsisLifecycleListener.this.isSuspended()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" [currently suspended - ignoring]");
                }
                return;
            }
            this.doRun();
        }

        protected abstract void doRun();
    }
}

