/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jdo.FetchPlan;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer2;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.NotYetImplementedException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.PojoRefreshException;
import org.apache.isis.core.runtime.persistence.UnsupportedFindException;
import org.apache.isis.core.runtime.persistence.adapter.PojoAdapterFactory;
import org.apache.isis.core.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindByPattern;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindByTitle;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.ObjectStore;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusApplicationComponents;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.FrameworkSynchronizer;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.commands.DataNucleusCreateObjectCommand;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.commands.DataNucleusDeleteObjectCommand;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.commands.DataNucleusUpdateObjectCommand;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindAllInstancesProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindByPatternProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindByTitleProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindUsingApplibQueryProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.QueryUtil;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.spi.JdoObjectIdSerializer;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoNamedQuery;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.enhancement.Persistable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNucleusObjectStore
implements ObjectStore {
    private static final Logger LOG = LoggerFactory.getLogger(DataNucleusObjectStore.class);
    private static final String ROOT_KEY = "isis.persistor.datanucleus.";
    public static final String DATANUCLEUS_PROPERTIES_ROOT = "isis.persistor.datanucleus.impl.";
    public static final String INSTALL_FIXTURES_KEY = "isis.persistor.datanucleus.install-fixtures";
    public static final boolean INSTALL_FIXTURES_DEFAULT = false;
    private final ObjectAdapterFactory adapterFactory;
    private final DataNucleusApplicationComponents applicationComponents;
    private final Map<ObjectSpecId, RootOid> registeredServices = Maps.newHashMap();
    private PersistenceManager persistenceManager;
    private final Map<Class<?>, PersistenceQueryProcessor<?>> persistenceQueryProcessorByClass = Maps.newHashMap();
    private final FrameworkSynchronizer frameworkSynchronizer;
    private State state;
    private TransactionMode transactionMode;

    public DataNucleusObjectStore(DataNucleusApplicationComponents applicationComponents) {
        PojoAdapterFactory adapterFactory = new PojoAdapterFactory();
        Ensure.ensureThatArg((Object)adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)applicationComponents, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.state = State.NOT_YET_OPEN;
        this.transactionMode = TransactionMode.UNCHAINED;
        this.adapterFactory = adapterFactory;
        this.applicationComponents = applicationComponents;
        this.frameworkSynchronizer = applicationComponents.getFrameworkSynchronizer();
    }

    @Override
    public String name() {
        return "datanucleus";
    }

    public void open() {
        this.ensureNotYetOpen();
        this.openSession();
        Ensure.ensureThatState((Object)this.persistenceManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.addPersistenceQueryProcessors(this.persistenceManager);
        this.state = State.OPEN;
    }

    public void close() {
        this.ensureOpened();
        Ensure.ensureThatState((Object)this.persistenceManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        try {
            IsisTransaction currentTransaction = this.getTransactionManager().getTransaction();
            if (currentTransaction != null && !currentTransaction.getState().isComplete()) {
                if (currentTransaction.getState().canCommit()) {
                    this.getTransactionManager().endTransaction();
                } else if (currentTransaction.getState().canAbort()) {
                    this.getTransactionManager().abortTransaction();
                }
            }
        }
        finally {
            this.persistenceManager.close();
            this.state = State.CLOSED;
        }
    }

    private PersistenceManager openSession() {
        this.persistenceManager = this.applicationComponents.createPersistenceManager();
        return this.persistenceManager;
    }

    private void addPersistenceQueryProcessors(PersistenceManager persistenceManager) {
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindAllInstances.class, new PersistenceQueryFindAllInstancesProcessor(persistenceManager, this.frameworkSynchronizer));
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindByTitle.class, new PersistenceQueryFindByTitleProcessor(persistenceManager, this.frameworkSynchronizer));
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindByPattern.class, new PersistenceQueryFindByPatternProcessor(persistenceManager, this.frameworkSynchronizer));
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindUsingApplibQueryDefault.class, new PersistenceQueryFindUsingApplibQueryProcessor(persistenceManager, this.frameworkSynchronizer));
    }

    @Override
    public boolean isFixturesInstalled() {
        boolean installFixtures = this.getConfiguration().getBoolean(INSTALL_FIXTURES_KEY, false);
        LOG.info("isFixturesInstalled: {} = {}", (Object)INSTALL_FIXTURES_KEY, (Object)installFixtures);
        return !installFixtures;
    }

    @Override
    public void reset() {
    }

    public Connection getJavaSqlConnection() {
        return (Connection)this.persistenceManager.getDataStoreConnection().getNativeConnection();
    }

    public TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public void setTransactionMode(TransactionMode transactionMode) {
        this.ensureNotInTransaction();
        this.transactionMode = transactionMode;
    }

    @Override
    public void startTransaction() {
        this.beginJdoTransaction();
    }

    @Override
    public void endTransaction() {
        this.commitJdoTransaction();
    }

    @Override
    public void abortTransaction() {
        this.rollbackJdoTransaction();
    }

    private void beginJdoTransaction() {
        Transaction transaction = this.getPersistenceManager().currentTransaction();
        if (transaction.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        transaction.begin();
    }

    private void commitJdoTransaction() {
        Transaction transaction = this.getPersistenceManager().currentTransaction();
        if (transaction.isActive()) {
            transaction.commit();
        }
    }

    private void rollbackJdoTransaction() {
        Transaction transaction = this.getPersistenceManager().currentTransaction();
        if (transaction.isActive()) {
            transaction.rollback();
        }
    }

    @Override
    public CreateObjectCommand createCreateObjectCommand(ObjectAdapter adapter) {
        this.ensureOpened();
        this.ensureInSession();
        if (LOG.isDebugEnabled()) {
            LOG.debug("create object - creating command for: " + adapter);
        }
        if (adapter.representsPersistent()) {
            throw new IllegalArgumentException("Adapter is persistent; adapter: " + adapter);
        }
        return new DataNucleusCreateObjectCommand(adapter, this.getPersistenceManager());
    }

    @Override
    public SaveObjectCommand createSaveObjectCommand(ObjectAdapter adapter) {
        this.ensureOpened();
        this.ensureInSession();
        if (!adapter.representsPersistent()) {
            throw new IllegalArgumentException("Adapter is not persistent; adapter: " + adapter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("save object - creating command for: " + adapter);
        }
        return new DataNucleusUpdateObjectCommand(adapter, this.getPersistenceManager());
    }

    @Override
    public DestroyObjectCommand createDestroyObjectCommand(ObjectAdapter adapter) {
        this.ensureOpened();
        this.ensureInSession();
        if (LOG.isDebugEnabled()) {
            LOG.debug("destroy object - creating command for: " + adapter);
        }
        if (!adapter.representsPersistent()) {
            throw new IllegalArgumentException("Adapter is not persistent; adapter: " + adapter);
        }
        return new DataNucleusDeleteObjectCommand(adapter, this.getPersistenceManager());
    }

    @Override
    public void execute(List<PersistenceCommand> commands) {
        this.ensureOpened();
        this.ensureInTransaction();
        this.executeCommands(commands);
    }

    private void executeCommands(List<PersistenceCommand> commands) {
        for (PersistenceCommand command : commands) {
            command.execute(null);
        }
        this.getPersistenceManager().flush();
    }

    @Override
    public ObjectAdapter loadInstanceAndAdapt(TypedOid oid) {
        this.ensureOpened();
        this.ensureInTransaction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getObject; oid=" + oid);
        }
        Object pojo = this.loadPojo(oid);
        return this.getPersistenceSession().getAdapterManager().mapRecreatedPojo((Oid)oid, pojo);
    }

    public Object loadPojo(TypedOid oid) {
        if (oid instanceof AggregatedOid) {
            throw new UnsupportedOperationException("Cannot retrieve aggregated objects directly, oid: " + oid.enString(this.getOidMarshaller()));
        }
        RootOid rootOid = (RootOid)oid;
        Object result = null;
        try {
            Class<?> cls = this.clsOf((TypedOid)rootOid);
            Object jdoObjectId = JdoObjectIdSerializer.toJdoObjectId(rootOid);
            PersistenceManager pm = this.getPersistenceManager();
            FetchPlan fetchPlan = pm.getFetchPlan();
            fetchPlan.addGroup("default");
            result = pm.getObjectById(cls, jdoObjectId);
        }
        catch (RuntimeException e) {
            List exceptionRecognizers = this.getPersistenceSession().getServicesInjector().lookupServices(ExceptionRecognizer.class);
            for (ExceptionRecognizer exceptionRecognizer : exceptionRecognizers) {
                ExceptionRecognizer2 recognizer;
                ExceptionRecognizer2.Recognition recognition;
                if (!(exceptionRecognizer instanceof ExceptionRecognizer2) || (recognition = (recognizer = (ExceptionRecognizer2)exceptionRecognizer).recognize2((Throwable)e)) == null || recognition.getCategory() != ExceptionRecognizer2.Category.NOT_FOUND) continue;
                throw new ObjectNotFoundException((Oid)oid, (Throwable)e);
            }
            throw e;
        }
        if (result == null) {
            throw new ObjectNotFoundException((Oid)oid);
        }
        return result;
    }

    public ObjectAdapter lazilyLoaded(Object pojo) {
        if (!(pojo instanceof Persistable)) {
            return null;
        }
        Persistable persistenceCapable = (Persistable)pojo;
        return this.frameworkSynchronizer.lazilyLoaded(persistenceCapable, FrameworkSynchronizer.CalledFrom.OS_LAZILYLOADED);
    }

    @Override
    public void resolveImmediately(ObjectAdapter adapter) {
        this.ensureOpened();
        this.ensureInTransaction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("resolveImmediately; oid=" + adapter.getOid().enString(this.getOidMarshaller()));
        }
        if (adapter.isResolved()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("; already resolved - ignoring");
            }
            return;
        }
        if (!adapter.representsPersistent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("; not persistent - ignoring");
            }
            return;
        }
        Oid oid = adapter.getOid();
        if (oid instanceof AggregatedOid) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("; aggregated - resolving parent");
            }
            AggregatedOid aggregatedOid = (AggregatedOid)oid;
            TypedOid parentOid = aggregatedOid.getParentOid();
            ObjectAdapter parentAdapter = this.loadInstanceAndAdapt(parentOid);
            this.resolveImmediately(parentAdapter);
            return;
        }
        this.refreshRoot(adapter);
    }

    public void refreshRoot(ObjectAdapter adapter) {
        Object domainObject = adapter.getObject();
        if (domainObject == null) {
            throw new PojoRefreshException(adapter.getOid());
        }
        try {
            this.getPersistenceManager().refresh(domainObject);
        }
        catch (RuntimeException e) {
            throw new PojoRefreshException(adapter.getOid(), (Throwable)e);
        }
        this.frameworkSynchronizer.postLoadProcessingFor((Persistable)domainObject, FrameworkSynchronizer.CalledFrom.OS_RESOLVE);
    }

    @Override
    public List<ObjectAdapter> loadInstancesAndAdapt(PersistenceQuery persistenceQuery) {
        this.ensureOpened();
        this.ensureInTransaction();
        PersistenceQueryProcessor<?> processor = this.persistenceQueryProcessorByClass.get(persistenceQuery.getClass());
        if (processor == null) {
            throw new UnsupportedFindException(MessageFormat.format("Unsupported criteria type: {0}", persistenceQuery.getClass().getName()));
        }
        return this.processPersistenceQuery(processor, persistenceQuery);
    }

    private <Q extends PersistenceQuery> List<ObjectAdapter> processPersistenceQuery(PersistenceQueryProcessor<Q> persistenceQueryProcessor, PersistenceQuery persistenceQuery) {
        return persistenceQueryProcessor.process(persistenceQuery);
    }

    @Override
    public boolean hasInstances(ObjectSpecification specification) {
        this.ensureOpened();
        this.ensureInTransaction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("hasInstances: class=" + specification.getFullIdentifier());
        }
        if (!specification.persistability().isPersistable()) {
            LOG.warn("hasInstances: trying to run for non-persistent class " + specification);
            return false;
        }
        Query jdoQuery = QueryUtil.createQuery(this.getPersistenceManager(), "o", "select o.id", specification, null);
        throw new NotYetImplementedException();
    }

    private List<ObjectAdapter> loadObjects(ObjectSpecification specification, List<?> listOfPojs, AdapterManagerDefault adapterManager) {
        ArrayList adapters = Lists.newArrayList();
        boolean i = false;
        for (Object pojo : listOfPojs) {
            adapters.add(adapterManager.getAdapterFor(pojo));
        }
        return adapters;
    }

    @Override
    public void registerService(RootOid rootOid) {
        this.ensureOpened();
        this.registeredServices.put(rootOid.getObjectSpecId(), rootOid);
    }

    @Override
    public RootOid getOidForService(ObjectSpecification serviceSpec) {
        this.ensureOpened();
        return this.registeredServices.get(serviceSpec.getSpecId());
    }

    public boolean isDeleted(ObjectAdapter adapter) {
        return NucleusJDOHelper.isDeleted((Object)adapter.getObject());
    }

    private void ensureNotYetOpen() {
        this.ensureStateIs(State.NOT_YET_OPEN);
    }

    private void ensureOpened() {
        this.ensureStateIs(State.OPEN);
    }

    private void ensureInSession() {
        Ensure.ensureThatContext((Object)IsisContext.inSession(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void ensureNotInTransaction() {
        this.ensureInSession();
        Ensure.ensureThatContext((Object)IsisContext.inTransaction(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void ensureInTransaction() {
        if (this.transactionMode == TransactionMode.UNCHAINED) {
            Ensure.ensureThatContext((Object)IsisContext.inTransaction(), (Matcher)CoreMatchers.is((Object)true));
            this.ensureInHibernateTransaction();
        } else {
            this.ensureInSession();
            if (IsisContext.inTransaction()) {
                this.ensureInHibernateTransaction();
            } else {
                this.getTransactionManager().startTransaction();
            }
        }
    }

    private void ensureInHibernateTransaction() {
        Transaction currentTransaction = this.getPersistenceManager().currentTransaction();
        Ensure.ensureThatState((Object)currentTransaction, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)currentTransaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void ensureStateIs(State stateRequired) {
        if (this.state == stateRequired) {
            return;
        }
        throw new IllegalStateException("State is: " + (Object)((Object)this.state) + "; should be: " + (Object)((Object)stateRequired));
    }

    public void debugData(DebugBuilder debug) {
        debug.append((Object)"this object store does not currently provide any debug data");
    }

    public String debugTitle() {
        return "JDO (DataNucleus) ObjectStore";
    }

    public JdoNamedQuery getNamedQuery(String queryName) {
        return this.applicationComponents.getNamedQuery(queryName);
    }

    public void suspendListener() {
        this.applicationComponents.suspendListener();
    }

    public void resumeListener() {
        this.applicationComponents.resumeListener();
    }

    private Class<?> clsOf(TypedOid oid) {
        ObjectSpecification objectSpec = this.getSpecificationLoader().lookupBySpecId(oid.getObjectSpecId());
        return objectSpec.getCorrespondingClass();
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public ObjectAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    static enum TransactionMode {
        UNCHAINED,
        CHAINED;

    }

    static enum State {
        NOT_YET_OPEN,
        OPEN,
        CLOSED;

    }
}

