/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryServiceUsingReflections;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.fixtures.FixturesInstaller;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.reflections.Reflections;
import org.reflections.vfs.Vfs;

public abstract class IsisComponentProviderAbstract
implements IsisComponentProvider {
    protected final DeploymentType deploymentType;
    protected final AppManifest appManifest;
    protected IsisConfiguration configuration;
    protected List<Object> services;
    protected FixturesInstaller fixturesInstaller;
    protected AuthenticationManager authenticationManager;
    protected AuthorizationManager authorizationManager;

    public IsisComponentProviderAbstract(DeploymentType deploymentType, AppManifest appManifest) {
        this.deploymentType = deploymentType;
        this.appManifest = appManifest;
    }

    protected void putAppManifestKey(AppManifest appManifest) {
        this.putConfigurationProperty("isis.appManifest", appManifest.getClass().getName());
    }

    protected void ensureInitialized() {
        Ensure.ensureThatState((Object)this.authenticationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.authorizationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState(this.services, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.fixturesInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"fixtureInstaller could not be looked up");
    }

    protected void specifyServicesAndRegisteredEntitiesUsing(AppManifest appManifest) {
        Iterable<String> packageNames = this.modulePackageNamesFrom(appManifest);
        String packageNamesCsv = Joiner.on((char)',').join(packageNames);
        this.putConfigurationProperty("isis.services.ServicesInstallerFromAnnotation.packagePrefix", packageNamesCsv);
        this.putConfigurationProperty("isis.persistor.datanucleus.RegisterEntities.packagePrefix", packageNamesCsv);
        List additionalServices = appManifest.getAdditionalServices();
        if (additionalServices != null) {
            this.putConfigurationProperty("isis.services", this.classNamesFrom(additionalServices));
        }
    }

    protected void registerPackageNames(AppManifest appManifest) {
        Iterable<String> packageNameList = this.modulePackageNamesFrom(appManifest);
        AppManifest.Registry registry = AppManifest.Registry.instance();
        ArrayList packages = Lists.newArrayList();
        packages.addAll(AppManifest.Registry.FRAMEWORK_PROVIDED_SERVICES);
        Iterables.addAll((Collection)packages, packageNameList);
        Vfs.setDefaultURLTypes((List)ClassDiscoveryServiceUsingReflections.getUrlTypes());
        Reflections reflections = new Reflections(new Object[]{packages});
        Set domainServiceTypes = reflections.getTypesAnnotatedWith(DomainService.class);
        Set persistenceCapableTypes = reflections.getTypesAnnotatedWith(PersistenceCapable.class);
        Set fixtureScriptTypes = reflections.getSubTypesOf(FixtureScript.class);
        registry.setDomainServiceTypes(domainServiceTypes);
        registry.setPersistenceCapableTypes(persistenceCapableTypes);
        registry.setFixtureScriptTypes(fixtureScriptTypes);
    }

    private Iterable<String> modulePackageNamesFrom(AppManifest appManifest) {
        List modules = appManifest.getModules();
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("If an appManifest is provided then it must return a non-empty set of modules");
        }
        return Iterables.transform((Iterable)modules, (Function)ClassUtil.Functions.packageNameOf());
    }

    protected String classNamesFrom(List<?> objectsOrClasses) {
        if (objectsOrClasses == null) {
            return null;
        }
        Iterable fixtureClassNames = Iterables.transform(objectsOrClasses, IsisComponentProviderAbstract.classNameOf());
        return Joiner.on((char)',').join(fixtureClassNames);
    }

    private static Function<Object, String> classNameOf() {
        return new Function<Object, String>(){

            @Nullable
            public String apply(Object input) {
                Class<?> aClass = input instanceof Class ? (Class<?>)input : input.getClass();
                return aClass.getName();
            }
        };
    }

    protected void overrideConfigurationUsing(AppManifest appManifest) {
        Map configurationProperties = appManifest.getConfigurationProperties();
        if (configurationProperties != null) {
            for (Map.Entry configProp : configurationProperties.entrySet()) {
                this.putConfigurationProperty((String)configProp.getKey(), (String)configProp.getValue());
            }
        }
    }

    protected final void putConfigurationProperty(String key, String value) {
        if (value == null) {
            return;
        }
        this.doPutConfigurationProperty(key, value);
    }

    protected abstract void doPutConfigurationProperty(String var1, String var2);

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public AuthenticationManager provideAuthenticationManager(DeploymentType deploymentType) {
        return this.authenticationManager;
    }

    @Override
    public AuthorizationManager provideAuthorizationManager(DeploymentType deploymentType) {
        return this.authorizationManager;
    }

    @Override
    public FixturesInstaller provideFixturesInstaller() {
        return this.fixturesInstaller;
    }

    @Override
    public List<Object> provideServices() {
        return this.services;
    }
}

