/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.transaction;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.PublishedAction;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.actinvoc.ActionInvocationContext;
import org.apache.isis.applib.services.audit.AuditingService3;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.Command2;
import org.apache.isis.applib.services.command.Command3;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.applib.services.publish.EventMetadata;
import org.apache.isis.applib.services.publish.EventPayload;
import org.apache.isis.applib.services.publish.EventPayloadForActionInvocation;
import org.apache.isis.applib.services.publish.EventPayloadForObjectChanged;
import org.apache.isis.applib.services.publish.EventSerializer;
import org.apache.isis.applib.services.publish.EventType;
import org.apache.isis.applib.services.publish.ObjectStringifier;
import org.apache.isis.applib.services.publish.PublishingService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.commons.components.TransactionScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PublishingServiceWithDefaultPayloadFactories;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.TransactionalResource;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionFlushException;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisTransaction
implements TransactionScopedComponent {
    public static final Predicate<ObjectAdapter> IS_COMMAND = new Predicate<ObjectAdapter>(){

        public boolean apply(ObjectAdapter input) {
            return Command.class.isAssignableFrom(input.getSpecification().getCorrespondingClass());
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(IsisTransaction.class);
    private final TransactionalResource objectStore;
    private final List<PersistenceCommand> persistenceCommands = Lists.newArrayList();
    private final IsisTransactionManager transactionManager;
    private final MessageBroker messageBroker;
    private final ServicesInjector servicesInjector;
    private final Command command;
    private final CommandContext commandContext;
    private final AuditingService3 auditingService3;
    private final PublishingServiceWithDefaultPayloadFactories publishingService;
    private final UUID transactionId;
    private State state;
    private IsisException abortCause;
    private static final int MAX_FLUSH_ATTEMPTS = 10;
    private final Map<ObjectAdapter, PublishedObject.ChangeKind> changeKindByEnlistedAdapter = Maps.newLinkedHashMap();
    private final Map<AdapterAndProperty, PreAndPostValues> changedObjectProperties = Maps.newLinkedHashMap();
    private ObjectStringifier objectStringifier;

    public IsisTransaction(IsisTransactionManager transactionManager, MessageBroker messageBroker, TransactionalResource objectStore, ServicesInjector servicesInjector) {
        Ensure.ensureThatArg((Object)transactionManager, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())), (String)"transaction manager is required");
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())), (String)"message broker is required");
        Ensure.ensureThatArg((Object)servicesInjector, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())), (String)"services injector is required");
        this.transactionManager = transactionManager;
        this.messageBroker = messageBroker;
        this.servicesInjector = servicesInjector;
        this.commandContext = (CommandContext)servicesInjector.lookupService(CommandContext.class);
        this.auditingService3 = (AuditingService3)servicesInjector.lookupService(AuditingService3.class);
        this.publishingService = this.getPublishingServiceIfAny(servicesInjector);
        UUID previousTransactionId = null;
        if (this.commandContext != null) {
            this.command = this.commandContext.getCommand();
            previousTransactionId = this.command.getTransactionId();
        } else {
            this.command = null;
        }
        this.transactionId = previousTransactionId != null ? previousTransactionId : UUID.randomUUID();
        this.state = State.IN_PROGRESS;
        this.objectStore = objectStore;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new transaction " + this);
        }
    }

    private PublishingServiceWithDefaultPayloadFactories getPublishingServiceIfAny(ServicesInjector servicesInjector) {
        PublishedAction.PayloadFactory actionPayloadFactory;
        PublishingService publishingService = (PublishingService)servicesInjector.lookupService(PublishingService.class);
        if (publishingService == null) {
            return null;
        }
        PublishedObject.PayloadFactory objectPayloadFactory = (PublishedObject.PayloadFactory)servicesInjector.lookupService(PublishedObject.PayloadFactory.class);
        if (objectPayloadFactory == null) {
            objectPayloadFactory = this.newDefaultObjectPayloadFactory();
        }
        if ((actionPayloadFactory = (PublishedAction.PayloadFactory)servicesInjector.lookupService(PublishedAction.PayloadFactory.class)) == null) {
            actionPayloadFactory = this.newDefaultActionPayloadFactory();
        }
        return new PublishingServiceWithDefaultPayloadFactories(publishingService, objectPayloadFactory, actionPayloadFactory);
    }

    protected EventSerializer newSimpleEventSerializer() {
        return new EventSerializer.Simple();
    }

    protected PublishedObject.PayloadFactory newDefaultObjectPayloadFactory() {
        return new PublishedObject.PayloadFactory(){

            public EventPayload payloadFor(Object changedObject, PublishedObject.ChangeKind changeKind) {
                return new EventPayloadForObjectChanged(changedObject);
            }
        };
    }

    protected PublishedAction.PayloadFactory newDefaultActionPayloadFactory() {
        return new PublishedAction.PayloadFactory(){

            public EventPayload payloadFor(Identifier actionIdentifier, Object target, List<Object> arguments, Object result) {
                return new EventPayloadForActionInvocation(actionIdentifier, target, arguments, result);
            }
        };
    }

    public final UUID getTransactionId() {
        return this.transactionId;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    public void addCommand(PersistenceCommand command) {
        if (command == null) {
            return;
        }
        ObjectAdapter onObject = command.onAdapter();
        if (command instanceof SaveObjectCommand) {
            if (this.alreadyHasCreate(onObject) || this.alreadyHasSave(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored command as object already created/saved" + command);
                }
                return;
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored command " + command + " as object no longer exists");
                }
                return;
            }
        }
        if (command instanceof DestroyObjectCommand) {
            if (this.alreadyHasCreate(onObject)) {
                this.removeCreate(onObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored both create and destroy command " + command);
                }
                return;
            }
            if (this.alreadyHasSave(onObject)) {
                this.removeSave(onObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removed prior save command " + command);
                }
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored command " + command + " as command already recorded");
                }
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("add command " + command);
        }
        this.persistenceCommands.add(command);
    }

    public final synchronized void flush() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flush transaction " + this);
        }
        try {
            this.doFlush();
        }
        catch (RuntimeException ex) {
            this.setAbortCause(new IsisTransactionFlushException(ex));
            throw ex;
        }
    }

    private void doFlush() {
        boolean i = false;
        do {
            ArrayList persistenceCommandList;
            if ((persistenceCommandList = Lists.newArrayList(this.persistenceCommands)).isEmpty()) continue;
            this.persistenceCommands.removeAll(persistenceCommandList);
            try {
                this.objectStore.execute(persistenceCommandList);
                for (PersistenceCommand persistenceCommand : persistenceCommandList) {
                    if (!(persistenceCommand instanceof DestroyObjectCommand)) continue;
                    ObjectAdapter adapter = persistenceCommand.onAdapter();
                    adapter.setVersion(null);
                    if (adapter.isDestroyed()) continue;
                    adapter.changeState(ResolveState.DESTROYED);
                }
            }
            catch (RuntimeException ex) {
                this.persistenceCommands.clear();
                throw ex;
            }
        } while (!this.persistenceCommands.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAudit(Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties) {
        try {
            if (this.auditingService3 == null) {
                return;
            }
            String currentUser = this.getTransactionManager().getAuthenticationSession().getUserName();
            Timestamp currentTime = Clock.getTimeAsJavaSqlTimestamp();
            for (Map.Entry<AdapterAndProperty, PreAndPostValues> auditEntry : changedObjectProperties) {
                this.auditChangedProperty(currentTime, currentUser, auditEntry);
            }
        }
        finally {
            this.changedObjectProperties.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishActionIfRequired(String currentUser, Timestamp timestamp) {
        if (this.publishingService == null) {
            return;
        }
        try {
            List<Class<?>> parameterTypes;
            List<String> parameterNames;
            Class returnType;
            ActionInvocationFacet.CurrentInvocation currentInvocation = (ActionInvocationFacet.CurrentInvocation)ActionInvocationFacet.currentInvocation.get();
            if (currentInvocation == null) {
                return;
            }
            IdentifiedHolder action = currentInvocation.getAction();
            PublishedActionFacet publishedActionFacet = (PublishedActionFacet)action.getFacet(PublishedActionFacet.class);
            if (publishedActionFacet == null) {
                return;
            }
            PublishedAction.PayloadFactory payloadFactory = (PublishedAction.PayloadFactory)publishedActionFacet.value();
            RootOid adapterOid = (RootOid)currentInvocation.getTarget().getOid();
            String oidStr = this.getOidMarshaller().marshal(adapterOid);
            Identifier actionIdentifier = action.getIdentifier();
            String title = oidStr + ": " + actionIdentifier.toNameParmsIdentityString();
            Command command = currentInvocation.getCommand();
            String targetClass = command.getTargetClass();
            String targetAction = command.getTargetAction();
            Bookmark target = command.getTarget();
            String memberIdentifier = command.getMemberIdentifier();
            if (action instanceof FacetedMethod) {
                FacetedMethod facetedMethod = (FacetedMethod)action;
                returnType = facetedMethod.getType();
                List parameters = facetedMethod.getParameters();
                parameterNames = IsisTransaction.immutableList(Iterables.transform((Iterable)parameters, (Function)FacetedMethodParameter.Functions.GET_NAME));
                parameterTypes = IsisTransaction.immutableList(Iterables.transform((Iterable)parameters, (Function)FacetedMethodParameter.Functions.GET_TYPE));
            } else {
                parameterNames = null;
                parameterTypes = null;
                returnType = null;
            }
            EventMetadata metadata = this.newEventMetadata(EventType.ACTION_INVOCATION, currentUser, timestamp, title, targetClass, targetAction, target, memberIdentifier, parameterNames, parameterTypes, returnType);
            this.publishingService.publishAction(payloadFactory, metadata, currentInvocation, this.objectStringifier());
        }
        finally {
            ActionInvocationFacet.currentInvocation.set(null);
        }
    }

    private static <T> List<T> immutableList(Iterable<T> iterable) {
        return Collections.unmodifiableList(Lists.newArrayList(iterable));
    }

    protected List<ObjectAdapter> publishedChangedObjectsIfRequired(String currentUser, Timestamp timestamp) {
        if (this.publishingService == null) {
            return Collections.emptyList();
        }
        ArrayList enlistedAdapters = Lists.newArrayList(this.changeKindByEnlistedAdapter.keySet());
        for (ObjectAdapter enlistedAdapter : enlistedAdapters) {
            String oidStr;
            PublishedObject.ChangeKind changeKind = this.changeKindByEnlistedAdapter.get(enlistedAdapter);
            PublishedObjectFacet publishedObjectFacet = (PublishedObjectFacet)enlistedAdapter.getSpecification().getFacet(PublishedObjectFacet.class);
            if (publishedObjectFacet == null) continue;
            PublishedObject.PayloadFactory payloadFactory = (PublishedObject.PayloadFactory)publishedObjectFacet.value();
            RootOid enlistedAdapterOid = (RootOid)enlistedAdapter.getOid();
            String title = oidStr = this.getOidMarshaller().marshal(enlistedAdapterOid);
            EventType eventTypeFor = IsisTransaction.eventTypeFor(changeKind);
            String enlistedAdapterClass = CommandUtil.targetClassNameFor((ObjectAdapter)enlistedAdapter);
            Bookmark enlistedTarget = enlistedAdapterOid.asBookmark();
            EventMetadata metadata = this.newEventMetadata(eventTypeFor, currentUser, timestamp, title, enlistedAdapterClass, null, enlistedTarget, null, null, null, null);
            this.publishingService.publishObject(payloadFactory, metadata, enlistedAdapter, changeKind, this.objectStringifier());
        }
        return enlistedAdapters;
    }

    private static EventType eventTypeFor(PublishedObject.ChangeKind changeKind) {
        if (changeKind == PublishedObject.ChangeKind.UPDATE) {
            return EventType.OBJECT_UPDATED;
        }
        if (changeKind == PublishedObject.ChangeKind.CREATE) {
            return EventType.OBJECT_CREATED;
        }
        if (changeKind == PublishedObject.ChangeKind.DELETE) {
            return EventType.OBJECT_DELETED;
        }
        throw new IllegalArgumentException("unknown ChangeKind '" + changeKind + "'");
    }

    protected ObjectStringifier objectStringifier() {
        if (this.objectStringifier == null) {
            this.objectStringifier = new ObjectStringifier(){

                public String toString(Object object) {
                    if (object == null) {
                        return null;
                    }
                    ObjectAdapter adapter = IsisTransaction.this.getAdapterManager().adapterFor(object);
                    Oid oid = adapter.getOid();
                    return oid != null ? oid.enString(IsisTransaction.this.getOidMarshaller()) : this.encodedValueOf(adapter);
                }

                private String encodedValueOf(ObjectAdapter adapter) {
                    EncodableFacet facet = (EncodableFacet)adapter.getSpecification().getFacet(EncodableFacet.class);
                    return facet != null ? facet.toEncodedString(adapter) : adapter.toString();
                }

                public String classNameOf(Object object) {
                    ObjectAdapter adapter = IsisTransaction.this.getAdapterManager().adapterFor(object);
                    String className = adapter.getSpecification().getFullIdentifier();
                    return className;
                }
            };
        }
        return this.objectStringifier;
    }

    private EventMetadata newEventMetadata(EventType eventType, String currentUser, Timestamp timestampEpoch, String title, String targetClass, String targetAction, Bookmark target, String memberIdentifier, List<String> parameterNames, List<Class<?>> parameterTypes, Class<?> returnType) {
        int nextEventSequence = this.nextEventSequence();
        return new EventMetadata(this.getTransactionId(), nextEventSequence, eventType, currentUser, timestampEpoch, title, targetClass, targetAction, target, memberIdentifier, parameterNames, parameterTypes, returnType);
    }

    private int nextEventSequence() {
        if (this.command == null) {
            throw new IllegalStateException("CommandContext service is required to support Publishing.");
        }
        return this.command.next("publishedEvent");
    }

    public void auditChangedProperty(Timestamp timestamp, String user, Map.Entry<AdapterAndProperty, PreAndPostValues> auditEntry) {
        AdapterAndProperty aap = auditEntry.getKey();
        ObjectAdapter adapter = aap.getAdapter();
        AuditableFacet auditableFacet = (AuditableFacet)adapter.getSpecification().getFacet(AuditableFacet.class);
        if (auditableFacet == null || auditableFacet.isDisabled()) {
            return;
        }
        Bookmark target = aap.getBookmark();
        String propertyId = aap.getPropertyId();
        String memberId = aap.getMemberId();
        PreAndPostValues papv = auditEntry.getValue();
        String preValue = papv.getPreString();
        String postValue = papv.getPostString();
        String targetClass = CommandUtil.targetClassNameFor((ObjectAdapter)adapter);
        this.auditingService3.audit(this.getTransactionId(), targetClass, target, memberId, propertyId, preValue, postValue, user, timestamp);
    }

    private static String asString(Object object) {
        return object != null ? object.toString() : null;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    synchronized void preCommit() {
        Ensure.ensureThatState((Object)this.getState().canCommit(), (Matcher)Matchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        Ensure.ensureThatState((Object)this.abortCause, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()), (String)"cannot commit: an abort cause has been set");
        if (LOG.isDebugEnabled()) {
            LOG.debug("preCommit transaction " + this);
        }
        if (this.getState() == State.COMMITTED) {
            if (LOG.isInfoEnabled()) {
                LOG.info("already committed; ignoring");
            }
            return;
        }
        try {
            LinkedHashMap processedObjectProperties = Maps.newLinkedHashMap();
            while (!this.changedObjectProperties.isEmpty()) {
                LinkedHashSet keys = Sets.newLinkedHashSet(this.changedObjectProperties.keySet());
                for (AdapterAndProperty aap : keys) {
                    PreAndPostValues papv = this.changedObjectProperties.remove(aap);
                    ObjectAdapter adapter = aap.getAdapter();
                    if (adapter.isDestroyed()) {
                        papv.setPost(Placeholder.DELETED);
                    } else {
                        papv.setPost(aap.getPropertyValue());
                    }
                    processedObjectProperties.put(aap, papv);
                }
            }
            Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties = Collections.unmodifiableSet(Sets.filter(processedObjectProperties.entrySet(), PreAndPostValues.Predicates.CHANGED));
            this.ensureCommandsPersistedIfDirtyXactnAndAnySafeSemanticsHonoured(changedObjectProperties);
            this.preCommitServices(changedObjectProperties);
        }
        catch (RuntimeException ex) {
            this.setAbortCause(new IsisTransactionManagerException(ex));
            this.clearCommandServiceIfConfigured();
            throw ex;
        }
    }

    private void ensureCommandsPersistedIfDirtyXactnAndAnySafeSemanticsHonoured(Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties) {
        CommandContext commandContext = this.getServiceOrNull(CommandContext.class);
        if (commandContext == null) {
            return;
        }
        Command command = commandContext.getCommand();
        if (command == null) {
            return;
        }
        Set<ObjectAdapter> changedAdapters = IsisTransaction.findChangedAdapters(changedObjectProperties);
        if (!changedAdapters.isEmpty() && command.getMemberIdentifier() != null) {
            command.setPersistHint(true);
        }
        this.ensureSafeSemanticsHonoured(command, changedAdapters);
    }

    private void ensureSafeSemanticsHonoured(Command command, Set<ObjectAdapter> changedAdapters) {
    }

    private List<? extends ActionDomainEvent<?>> flushActionDomainEvents(Command command) {
        if (command instanceof Command3) {
            Command3 command3 = (Command3)command;
            return command3.flushActionDomainEvents();
        }
        if (command instanceof Command2) {
            Command2 command2 = (Command2)command;
            return command2.flushActionInteractionEvents();
        }
        return Collections.emptyList();
    }

    private static Set<ObjectAdapter> findChangedAdapters(Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties) {
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(changedObjectProperties, AdapterAndProperty.Functions.GET_ADAPTER), (Predicate)Predicates.not(IS_COMMAND)));
    }

    private void preCommitServices(Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties) {
        this.doAudit(changedObjectProperties);
        String currentUser = this.getTransactionManager().getAuthenticationSession().getUserName();
        Timestamp endTimestamp = Clock.getTimeAsJavaSqlTimestamp();
        this.publishActionIfRequired(currentUser, endTimestamp);
        this.doFlush();
        this.publishedChangedObjectsIfRequired(currentUser, endTimestamp);
        this.doFlush();
        this.closeServices();
        this.doFlush();
    }

    private void clearCommandServiceIfConfigured() {
        this.completeCommandIfConfigured();
    }

    private void closeServices() {
        this.closeOtherApplibServicesIfConfigured();
        this.completeCommandIfConfigured();
    }

    public <T> T getServiceOrNull(Class<T> serviceType) {
        return (T)this.servicesInjector.lookupService(serviceType);
    }

    private void closeOtherApplibServicesIfConfigured() {
        ActionInvocationContext bic = this.getServiceOrNull(ActionInvocationContext.class);
        if (bic != null) {
            Bulk.InteractionContext.current.set(null);
        }
    }

    private void completeCommandIfConfigured() {
        CommandService commandService;
        CommandContext commandContext = this.getServiceOrNull(CommandContext.class);
        if (commandContext != null && (commandService = this.getServiceOrNull(CommandService.class)) != null) {
            Command command = commandContext.getCommand();
            commandService.complete(command);
            this.flushActionDomainEvents(command);
        }
    }

    public synchronized void commit() {
        Ensure.ensureThatState((Object)this.getState().canCommit(), (Matcher)Matchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        Ensure.ensureThatState((Object)this.abortCause, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()), (String)"cannot commit: an abort cause has been set");
        if (LOG.isDebugEnabled()) {
            LOG.debug("postCommit transaction " + this);
        }
        if (this.getState() == State.COMMITTED) {
            if (LOG.isInfoEnabled()) {
                LOG.info("already committed; ignoring");
            }
            return;
        }
        this.setState(State.COMMITTED);
    }

    public final synchronized void markAsAborted() {
        Ensure.ensureThatState((Object)this.getState().canAbort(), (Matcher)Matchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isInfoEnabled()) {
            LOG.info("abort transaction " + this);
        }
        this.setState(State.ABORTED);
    }

    @Deprecated
    public void ensureNoAbortCause() {
        Ensure.ensureThatArg((Object)this.abortCause, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()), (String)"abort cause has been set");
    }

    public void setAbortCause(IsisException abortCause) {
        this.setState(State.MUST_ABORT);
        this.abortCause = abortCause;
    }

    public IsisException getAbortCause() {
        return this.abortCause;
    }

    public void clearAbortCause() {
        this.abortCause = null;
    }

    private boolean alreadyHasCommand(Class<?> commandClass, ObjectAdapter onObject) {
        return this.getCommand(commandClass, onObject) != null;
    }

    private boolean alreadyHasCreate(ObjectAdapter onObject) {
        return this.alreadyHasCommand(CreateObjectCommand.class, onObject);
    }

    private boolean alreadyHasDestroy(ObjectAdapter onObject) {
        return this.alreadyHasCommand(DestroyObjectCommand.class, onObject);
    }

    private boolean alreadyHasSave(ObjectAdapter onObject) {
        return this.alreadyHasCommand(SaveObjectCommand.class, onObject);
    }

    private PersistenceCommand getCommand(Class<?> commandClass, ObjectAdapter onObject) {
        for (PersistenceCommand command : this.persistenceCommands) {
            if (!command.onAdapter().equals(onObject) || !commandClass.isAssignableFrom(command.getClass())) continue;
            return command;
        }
        return null;
    }

    private void removeCommand(Class<?> commandClass, ObjectAdapter onObject) {
        PersistenceCommand toDelete = this.getCommand(commandClass, onObject);
        this.persistenceCommands.remove(toDelete);
    }

    private void removeCreate(ObjectAdapter onObject) {
        this.removeCommand(CreateObjectCommand.class, onObject);
    }

    private void removeSave(ObjectAdapter onObject) {
        this.removeCommand(SaveObjectCommand.class, onObject);
    }

    public String toString() {
        return this.appendTo(new ToString((Object)this)).toString();
    }

    protected ToString appendTo(ToString str) {
        str.append("state", (Object)this.state);
        str.append("commands", this.persistenceCommands.size());
        return str;
    }

    public IsisTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public MessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    public void enlistCreated(ObjectAdapter adapter) {
        this.enlist(adapter, PublishedObject.ChangeKind.CREATE);
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            if (this.changedObjectProperties.containsKey(aap)) {
                return;
            }
            PreAndPostValues papv = PreAndPostValues.pre(Placeholder.NEW);
            this.changedObjectProperties.put(aap, papv);
        }
    }

    public void enlistUpdating(ObjectAdapter adapter) {
        this.enlist(adapter, PublishedObject.ChangeKind.UPDATE);
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            if (this.changedObjectProperties.containsKey(aap)) {
                return;
            }
            PreAndPostValues papv = PreAndPostValues.pre(aap.getPropertyValue());
            this.changedObjectProperties.put(aap, papv);
        }
    }

    public void enlistDeleting(ObjectAdapter adapter) {
        boolean enlisted = this.enlist(adapter, PublishedObject.ChangeKind.DELETE);
        if (!enlisted) {
            return;
        }
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            if (this.changedObjectProperties.containsKey(aap)) {
                return;
            }
            PreAndPostValues papv = PreAndPostValues.pre(aap.getPropertyValue());
            this.changedObjectProperties.put(aap, papv);
        }
    }

    private boolean enlist(ObjectAdapter adapter, PublishedObject.ChangeKind current) {
        PublishedObject.ChangeKind previous = this.changeKindByEnlistedAdapter.get(adapter);
        if (previous == null) {
            this.changeKindByEnlistedAdapter.put(adapter, current);
            return true;
        }
        switch (previous) {
            case CREATE: {
                switch (current) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.remove(adapter);
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case UPDATE: {
                switch (current) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.put(adapter, current);
                        return true;
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case DELETE: {
                return false;
            }
        }
        return previous == null;
    }

    protected AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    public static class PreAndPostValues {
        private final Object pre;
        private final String preString;
        private Object post;
        private String postString;

        public static PreAndPostValues pre(Object preValue) {
            return new PreAndPostValues(preValue, null);
        }

        private PreAndPostValues(Object pre, Object post) {
            this.pre = pre;
            this.post = post;
            this.preString = IsisTransaction.asString(pre);
        }

        public Object getPre() {
            return this.pre;
        }

        public String getPreString() {
            return this.preString;
        }

        public Object getPost() {
            return this.post;
        }

        public String getPostString() {
            return this.postString;
        }

        public void setPost(Object post) {
            this.post = post;
            this.postString = IsisTransaction.asString(post);
        }

        public String toString() {
            return this.getPre() + " -> " + this.getPost();
        }

        public boolean differ() {
            if (this.getPre() == Placeholder.NEW || this.getPost() == Placeholder.DELETED) {
                return true;
            }
            return !Objects.equal((Object)this.getPre(), (Object)this.getPost());
        }

        static class Predicates {
            static final Predicate<Map.Entry<?, PreAndPostValues>> CHANGED = new Predicate<Map.Entry<?, PreAndPostValues>>(){

                public boolean apply(Map.Entry<?, PreAndPostValues> input) {
                    PreAndPostValues papv = input.getValue();
                    return papv.differ();
                }
            };

            Predicates() {
            }
        }
    }

    public static class AdapterAndProperty {
        private final ObjectAdapter objectAdapter;
        private final ObjectAssociation property;
        private final Bookmark bookmark;
        private final String propertyId;
        private final String bookmarkStr;

        public static AdapterAndProperty of(ObjectAdapter adapter, ObjectAssociation property) {
            return new AdapterAndProperty(adapter, property);
        }

        private AdapterAndProperty(ObjectAdapter adapter, ObjectAssociation property) {
            this.objectAdapter = adapter;
            this.property = property;
            RootOid oid = (RootOid)adapter.getOid();
            String objectType = oid.getObjectSpecId().asString();
            String identifier = oid.getIdentifier();
            this.bookmark = new Bookmark(objectType, identifier);
            this.bookmarkStr = this.bookmark.toString();
            this.propertyId = property.getId();
        }

        public ObjectAdapter getAdapter() {
            return this.objectAdapter;
        }

        public ObjectAssociation getProperty() {
            return this.property;
        }

        public Bookmark getBookmark() {
            return this.bookmark;
        }

        public String getPropertyId() {
            return this.propertyId;
        }

        public String getMemberId() {
            return this.property.getIdentifier().toClassAndNameIdentityString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdapterAndProperty that = (AdapterAndProperty)o;
            if (this.bookmarkStr != null ? !this.bookmarkStr.equals(that.bookmarkStr) : that.bookmarkStr != null) {
                return false;
            }
            return !(this.propertyId != null ? !this.propertyId.equals(that.propertyId) : that.propertyId != null);
        }

        public int hashCode() {
            int result = this.propertyId != null ? this.propertyId.hashCode() : 0;
            result = 31 * result + (this.bookmarkStr != null ? this.bookmarkStr.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.bookmarkStr + " , " + this.getProperty().getId();
        }

        protected OidMarshaller getMarshaller() {
            return new OidMarshaller();
        }

        private Object getPropertyValue() {
            ObjectAdapter referencedAdapter = this.property.get(this.objectAdapter);
            return referencedAdapter == null ? null : referencedAdapter.getObject();
        }

        static class Functions {
            static final Function<Map.Entry<AdapterAndProperty, PreAndPostValues>, ObjectAdapter> GET_ADAPTER = new Function<Map.Entry<AdapterAndProperty, PreAndPostValues>, ObjectAdapter>(){

                public ObjectAdapter apply(Map.Entry<AdapterAndProperty, PreAndPostValues> input) {
                    AdapterAndProperty aap = input.getKey();
                    return aap.getAdapter();
                }
            };

            private Functions() {
            }
        }
    }

    public static enum State {
        IN_PROGRESS(RuntimeContext.TransactionState.IN_PROGRESS),
        MUST_ABORT(RuntimeContext.TransactionState.MUST_ABORT),
        COMMITTED(RuntimeContext.TransactionState.COMMITTED),
        ABORTED(RuntimeContext.TransactionState.ABORTED);

        public final RuntimeContext.TransactionState transactionState;

        private State(RuntimeContext.TransactionState transactionState) {
            this.transactionState = transactionState;
        }

        public boolean canFlush() {
            return this == IN_PROGRESS;
        }

        public boolean canCommit() {
            return this == IN_PROGRESS;
        }

        public boolean canAbort() {
            return this == IN_PROGRESS || this == MUST_ABORT;
        }

        public boolean isComplete() {
            return this == COMMITTED || this == ABORTED;
        }

        public boolean mustAbort() {
            return this == MUST_ABORT;
        }

        public RuntimeContext.TransactionState getRuntimeContextState() {
            return this.transactionState;
        }
    }

    private static class Placeholder {
        private static Placeholder NEW = new Placeholder("[NEW]");
        private static Placeholder DELETED = new Placeholder("[DELETED]");
        private final String str;

        public Placeholder(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

