/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;

public class OidGenerator
implements DebuggableWithTitle {
    private final IdentifierGenerator identifierGenerator;

    public OidGenerator(IdentifierGenerator identifierGenerator) {
        this.identifierGenerator = identifierGenerator;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public final RootOid createTransientOrViewModelOid(Object pojo) {
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(pojo.getClass());
        ObjectSpecId objectSpecId = spec.getSpecId();
        String transientIdentifier = this.identifierGenerator.createTransientIdentifierFor(objectSpecId, pojo);
        Oid.State state = spec.containsDoOpFacet(ViewModelFacet.class) ? Oid.State.VIEWMODEL : Oid.State.TRANSIENT;
        return new RootOidDefault(objectSpecId, transientIdentifier, state);
    }

    public AggregatedOid createAggregateOid(Object pojo, ObjectAdapter parentAdapter) {
        ObjectSpecId objectSpecId = this.objectSpecIdFor(pojo);
        String aggregateLocalId = this.identifierGenerator.createAggregateLocalId(objectSpecId, pojo, parentAdapter);
        return new AggregatedOid(objectSpecId, (TypedOid)parentAdapter.getOid(), aggregateLocalId);
    }

    public final RootOid createPersistentOrViewModelOid(Object pojo, RootOid transientRootOid) {
        ObjectSpecId objectSpecId = this.objectSpecIdFor(pojo);
        String persistentIdentifier = this.identifierGenerator.createPersistentIdentifierFor(objectSpecId, pojo, transientRootOid);
        ObjectSpecification spec = this.getSpecificationLoader().lookupBySpecId(objectSpecId);
        Oid.State state = spec != null && spec.containsFacet(ViewModelFacet.class) ? Oid.State.VIEWMODEL : Oid.State.PERSISTENT;
        return new RootOidDefault(objectSpecId, persistentIdentifier, state);
    }

    private ObjectSpecId objectSpecIdFor(Object pojo) {
        Class<?> cls = pojo.getClass();
        ObjectSpecification objectSpec = this.getSpecificationLoader().loadSpecification(cls);
        return objectSpec.getSpecId();
    }

    public void debugData(DebugBuilder debug) {
        this.getIdentifierGenerator().debugData(debug);
    }

    public String debugTitle() {
        return this.getIdentifierGenerator().debugTitle();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

