/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.runtime.PersistorImplementation;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;
import org.apache.isis.core.runtime.system.persistence.IdentifierGeneratorDefault;
import org.apache.isis.core.runtime.system.persistence.IdentifierGeneratorForDataNucleus;

public class IdentifierGeneratorUnified
implements IdentifierGenerator {
    private final IdentifierGenerator identifierGenerator;

    public IdentifierGeneratorUnified(IsisConfiguration configuration) {
        this.identifierGenerator = PersistorImplementation.from(configuration).isDataNucleus() ? new IdentifierGeneratorForDataNucleus() : new IdentifierGeneratorDefault();
    }

    @Override
    public String createTransientIdentifierFor(ObjectSpecId objectSpecId, Object pojo) {
        return this.identifierGenerator.createTransientIdentifierFor(objectSpecId, pojo);
    }

    @Override
    public String createAggregateLocalId(ObjectSpecId objectSpecId, Object pojo, ObjectAdapter parentAdapter) {
        return this.identifierGenerator.createAggregateLocalId(objectSpecId, pojo, parentAdapter);
    }

    @Override
    public String createPersistentIdentifierFor(ObjectSpecId objectSpecId, Object pojo, RootOid transientRootOid) {
        return this.identifierGenerator.createPersistentIdentifierFor(objectSpecId, pojo, transientRootOid);
    }

    @Override
    public <T extends IdentifierGenerator> T underlying(Class<T> cls) {
        return (T)(cls.isAssignableFrom(this.identifierGenerator.getClass()) ? (IdentifierGenerator)cls.cast(this.identifierGenerator) : null);
    }

    public String debugTitle() {
        return this.identifierGenerator.debugTitle();
    }

    public void debugData(DebugBuilder debug) {
        this.identifierGenerator.debugData(debug);
    }
}

