/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.userreg;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.applib.services.userreg.events.EmailEventAbstract;
import org.apache.isis.applib.services.userreg.events.EmailRegistrationEvent;
import org.apache.isis.applib.services.userreg.events.PasswordResetEvent;
import org.apache.isis.core.runtime.services.email.EmailServiceDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@DomainService(nature=NatureOfService.DOMAIN)
public class EmailNotificationServiceDefault
implements EmailNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(EmailNotificationServiceDefault.class);
    private static final Pattern EMAIL_PATTERN = Pattern.compile(Pattern.quote("${email}"));
    private static final Pattern CONFIRMATION_URL_PATTERN = Pattern.compile(Pattern.quote("${confirmationUrl}"));
    private static final Pattern APPLICATION_NAME_PATTERN = Pattern.compile(Pattern.quote("${applicationName}"));
    private String passwordResetTemplate;
    private String emailVerificationTemplate;
    private boolean initialized;
    @Inject
    private EmailServiceDefault emailService;

    @PostConstruct
    @Programmatic
    public void init() {
        if (this.initialized) {
            return;
        }
        this.emailVerificationTemplate = this.loadResource("EmailVerificationTemplate.html");
        this.passwordResetTemplate = this.loadResource("PasswordResetTemplate.html");
        this.initialized = true;
    }

    protected String loadResource(String resourceName) {
        URL templateUrl = Resources.getResource(EmailNotificationServiceDefault.class, (String)resourceName);
        try {
            return Resources.toString((URL)templateUrl, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to read resource URL '%s'", templateUrl));
        }
    }

    @Programmatic
    public boolean isConfigured() {
        return this.emailService != null && this.emailService.isConfigured();
    }

    @Programmatic
    public boolean send(EmailRegistrationEvent emailRegistrationEvent) {
        this.ensureConfigured();
        String body = this.replace(this.emailVerificationTemplate, (EmailEventAbstract)emailRegistrationEvent);
        return this.sendEmail((EmailEventAbstract)emailRegistrationEvent, body);
    }

    @Programmatic
    public boolean send(PasswordResetEvent passwordResetEvent) {
        this.ensureConfigured();
        String body = this.replace(this.passwordResetTemplate, (EmailEventAbstract)passwordResetEvent);
        return this.sendEmail((EmailEventAbstract)passwordResetEvent, body);
    }

    private void ensureConfigured() {
        if (!this.isConfigured()) {
            throw new IllegalStateException("Not configured");
        }
    }

    protected boolean sendEmail(EmailEventAbstract emailEvent, String body) {
        String subject = this.buildSubject(emailEvent);
        String to = emailEvent.getEmail();
        return this.sendEmail(to, subject, body);
    }

    protected String buildSubject(EmailEventAbstract emailEvent) {
        String subject = "[" + emailEvent.getApplicationName() + "]";
        if (emailEvent instanceof EmailRegistrationEvent) {
            subject = subject + " Please confirm your identity";
        } else if (emailEvent instanceof PasswordResetEvent) {
            subject = subject + " Password reset request";
        }
        return subject;
    }

    protected boolean sendEmail(String to, String subject, String body) {
        List<String> toList = Collections.singletonList(to);
        List<String> cc = Collections.emptyList();
        List<String> bcc = Collections.emptyList();
        return this.emailService.send(toList, cc, bcc, subject, body, new DataSource[0]);
    }

    protected String replace(String template, EmailEventAbstract emailEvent) {
        String message = template;
        message = EMAIL_PATTERN.matcher(message).replaceFirst(emailEvent.getEmail());
        message = CONFIRMATION_URL_PATTERN.matcher(message).replaceAll(emailEvent.getConfirmationUrl());
        message = APPLICATION_NAME_PATTERN.matcher(message).replaceAll(emailEvent.getApplicationName());
        return message;
    }
}

