/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.i18n.po;

import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.runtime.services.i18n.po.TranslationServicePo;

@DomainService
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.500")
public class TranslationServicePoMenu {
    @Inject
    private TranslationServicePo translationService;

    @Action(domainEvent=DownloadPotFileDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download")
    @MemberOrder(sequence="500.500.1")
    public Clob downloadTranslations(@ParameterLayout(named=".pot file name") String potFileName) {
        String chars = this.translationService.toPot();
        return new Clob(potFileName, "text/plain", (CharSequence)chars);
    }

    public String default0DownloadTranslations() {
        return "translations.pot";
    }

    public boolean hideDownloadTranslations() {
        return this.translationService.getMode().isRead();
    }

    @Action(domainEvent=ResetTranslationCacheDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(named="Clear translation cache", cssClassFa="fa-trash")
    @MemberOrder(sequence="500.500.2")
    public void resetTranslationCache() {
        this.translationService.clearCache();
    }

    public boolean hideResetTranslationCache() {
        return this.translationService.getMode().isWrite();
    }

    @Action(domainEvent=SwitchToReadingTranslationsDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-book")
    @MemberOrder(sequence="500.500.3")
    public void switchToReadingTranslations() {
        this.translationService.toggleMode();
    }

    public boolean hideSwitchToReadingTranslations() {
        return this.translationService.getMode().isRead();
    }

    @Action(domainEvent=SwitchToWritingTranslationsDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-pencil")
    @MemberOrder(sequence="500.500.4")
    public void switchToWritingTranslations() {
        this.translationService.toggleMode();
    }

    public boolean hideSwitchToWritingTranslations() {
        return this.translationService.getMode().isWrite();
    }

    public static class SwitchToWritingTranslationsDomainEvent
    extends ActionDomainEvent {
        public SwitchToWritingTranslationsDomainEvent(TranslationServicePoMenu source, Identifier identifier, Object ... arguments) {
            super(source, identifier, arguments);
        }
    }

    public static class SwitchToReadingTranslationsDomainEvent
    extends ActionDomainEvent {
        public SwitchToReadingTranslationsDomainEvent(TranslationServicePoMenu source, Identifier identifier, Object ... arguments) {
            super(source, identifier, arguments);
        }
    }

    public static class ResetTranslationCacheDomainEvent
    extends ActionDomainEvent {
        public ResetTranslationCacheDomainEvent(TranslationServicePoMenu source, Identifier identifier, Object ... arguments) {
            super(source, identifier, arguments);
        }
    }

    public static class DownloadPotFileDomainEvent
    extends ActionDomainEvent {
        public DownloadPotFileDomainEvent(TranslationServicePoMenu source, Identifier identifier, Object ... arguments) {
            super(source, identifier, arguments);
        }
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<TranslationServicePoMenu> {
        public ActionDomainEvent(TranslationServicePoMenu source, Identifier identifier) {
            super((Object)source, identifier);
        }

        public ActionDomainEvent(TranslationServicePoMenu source, Identifier identifier, Object ... arguments) {
            super((Object)source, identifier, arguments);
        }

        public ActionDomainEvent(TranslationServicePoMenu source, Identifier identifier, List<Object> arguments) {
            super((Object)source, identifier, arguments);
        }
    }
}

