/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.eventbus;

import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.eventbus.EventBusImplementation;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.apache.isis.core.runtime.services.eventbus.adapter.EventBusImplementationForAxonSimple;
import org.apache.isis.core.runtime.services.eventbus.adapter.EventBusImplementationForGuava;

public abstract class EventBusServiceDefault
extends EventBusService {
    public static final String KEY_ALLOW_LATE_REGISTRATION = "isis.services.eventbus.allowLateRegistration";
    public static final String KEY_EVENT_BUS_IMPLEMENTATION = "isis.services.eventbus.implementation";
    private boolean allowLateRegistration;
    private String implementation;

    public void register(Object domainService) {
        if (!(domainService instanceof RequestScopedService)) {
            if (Annotations.getAnnotation(domainService.getClass(), RequestScoped.class) != null) {
                throw new IllegalArgumentException("Request-scoped services must register their proxy, not themselves");
            }
            if (!this.allowLateRegistration && this.eventBusImplementation != null) {
                throw new IllegalStateException("Event bus has already been created; too late to register any further (singleton) subscribers");
            }
        }
        super.register(domainService);
    }

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
        this.allowLateRegistration = EventBusServiceDefault.getElseFalse(properties, KEY_ALLOW_LATE_REGISTRATION);
        this.implementation = EventBusServiceDefault.getNormalized(properties.get(KEY_EVENT_BUS_IMPLEMENTATION));
    }

    private static String getNormalized(String implementation) {
        if (Strings.isNullOrEmpty((String)implementation)) {
            return "guava";
        }
        String implementationTrimmed = implementation.trim();
        if ("guava".equalsIgnoreCase(implementationTrimmed)) {
            return "guava";
        }
        if ("axon".equalsIgnoreCase(implementationTrimmed)) {
            return "axon";
        }
        return implementationTrimmed;
    }

    private static boolean getElseFalse(Map<String, String> properties, String key) {
        String value = properties.get(key);
        return !Strings.isNullOrEmpty((String)value) && Boolean.parseBoolean(value);
    }

    boolean isAllowLateRegistration() {
        return this.allowLateRegistration;
    }

    String getImplementation() {
        return this.implementation;
    }

    protected EventBusImplementation newEventBus() {
        if ("guava".equals(this.implementation)) {
            return new EventBusImplementationForGuava();
        }
        if ("axon".equals(this.implementation)) {
            return new EventBusImplementationForAxonSimple();
        }
        Class aClass = ClassUtil.forName((String)this.implementation);
        if (EventBusImplementation.class.isAssignableFrom(aClass)) {
            try {
                return (EventBusImplementation)aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new NonRecoverableException((Throwable)e);
            }
        }
        throw new NonRecoverableException("Could not instantiate event bus implementation '" + this.implementation + "'");
    }
}

