/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.eventbus;

import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.EventBusImplementation;
import org.apache.isis.core.commons.exceptions.IsisApplicationException;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventBusImplementationAbstract
implements EventBusImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(EventBusImplementationAbstract.class);

    protected static void processException(Throwable exception, Object event) {
        if (!(event instanceof AbstractDomainEvent)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring exception '%s' (%s), not a subclass of AbstractDomainEvent", (Object)exception.getMessage(), (Object)exception.getClass().getName());
            }
            return;
        }
        AbstractDomainEvent interactionEvent = (AbstractDomainEvent)event;
        AbstractDomainEvent.Phase phase = interactionEvent.getEventPhase();
        switch (phase) {
            case HIDE: {
                LOG.warn("Exception thrown during HIDE phase, to be safe will veto (hide) the interaction event, msg='{}', class='{}'", (Object)exception.getMessage(), (Object)exception.getClass().getName());
                interactionEvent.hide();
                break;
            }
            case DISABLE: {
                LOG.warn("Exception thrown during DISABLE phase, to be safe will veto (disable) the interaction event, msg='{}', class='{}'", (Object)exception.getMessage(), (Object)exception.getClass().getName());
                interactionEvent.disable(exception.getMessage() != null ? exception.getMessage() : exception.getClass().getName() + " thrown.");
                break;
            }
            case VALIDATE: {
                LOG.warn("Exception thrown during VALIDATE phase, to be safe will veto (invalidate) the interaction event, msg='{}', class='{}'", (Object)exception.getMessage(), (Object)exception.getClass().getName());
                interactionEvent.invalidate(exception.getMessage() != null ? exception.getMessage() : exception.getClass().getName() + " thrown.");
                break;
            }
            case EXECUTING: {
                LOG.warn("Exception thrown during EXECUTING phase, to be safe will abort the transaction, msg='{}', class='{}'", (Object)exception.getMessage(), (Object)exception.getClass().getName());
                EventBusImplementationAbstract.abortTransaction(exception);
                break;
            }
            case EXECUTED: {
                LOG.warn("Exception thrown during EXECUTED phase, to be safe will abort the transaction, msg='{}', class='{}'", (Object)exception.getMessage(), (Object)exception.getClass().getName());
                EventBusImplementationAbstract.abortTransaction(exception);
            }
        }
    }

    private static void abortTransaction(Throwable exception) {
        EventBusImplementationAbstract.getTransactionManager().getTransaction().setAbortCause((IsisException)new IsisApplicationException(exception));
    }

    private static IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }
}

