/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.fixturedomainservice.ObjectFixtureService;
import org.apache.isis.core.runtime.services.DeweyOrderComparator;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstallerAbstract;
import org.apache.isis.core.runtime.services.ServicesInstallerUtils;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInstallerFromConfiguration
extends ServicesInstallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInstallerFromConfiguration.class);
    public static final String NAME = "configuration";
    private static final String SERVICES = "services";
    public static final String SERVICES_KEY = "isis.services";
    @Deprecated
    private static final String EXPLORATION_OBJECTS = "exploration-objects";
    @Deprecated
    private static final String SERVICES_PREFIX = "services.prefix";
    @Deprecated
    private static final String SERVICES_PREFIX_KEY = "isis.services.prefix";
    private static final Pattern POSITIONED_SERVICE_REGEX = Pattern.compile("((\\d+):)(.*)");
    private final ServiceInstantiator serviceInstantiator;
    private boolean initialized = false;
    private List<Object> serviceList;

    public ServicesInstallerFromConfiguration() {
        this(new ServiceInstantiator());
    }

    ServicesInstallerFromConfiguration(ServiceInstantiator serviceInstantiator) {
        super(NAME);
        this.serviceInstantiator = serviceInstantiator;
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
    }

    public void init() {
        this.initIfRequired();
    }

    protected void initIfRequired() {
        if (this.initialized) {
            return;
        }
        try {
            this.serviceInstantiator.setConfiguration(this.getConfiguration());
        }
        finally {
            this.initialized = true;
        }
    }

    @Override
    public List<Object> getServices() {
        LOG.info("installing " + this.getClass().getName());
        this.serviceInstantiator.setConfiguration(this.getConfiguration());
        if (this.serviceList == null) {
            TreeMap positionedServices = Maps.newTreeMap((Comparator)new DeweyOrderComparator());
            this.appendServices(positionedServices);
            this.serviceList = ServicesInstallerUtils.instantiateServicesFrom(positionedServices, this.serviceInstantiator);
        }
        return this.serviceList;
    }

    public void appendServices(SortedMap<String, SortedSet<String>> positionedServices) {
        this.appendConfiguredServices(positionedServices);
        ServicesInstallerFromConfiguration.appendObjectFixtureService(positionedServices, this.getConfiguration());
    }

    private void appendConfiguredServices(SortedMap<String, SortedSet<String>> positionedServices) {
        String servicePrefix = this.getConfiguration().getString(SERVICES_PREFIX_KEY);
        String configuredServices = this.getConfiguration().getString(SERVICES_KEY);
        if (configuredServices == null) {
            return;
        }
        StringTokenizer services = new StringTokenizer(configuredServices, ",");
        while (services.hasMoreTokens()) {
            String serviceName = services.nextToken().trim();
            if (serviceName.equals("")) continue;
            Matcher matcher = POSITIONED_SERVICE_REGEX.matcher(serviceName);
            Integer order = Integer.MAX_VALUE;
            if (matcher.matches()) {
                order = Integer.parseInt(matcher.group(2));
                serviceName = matcher.group(3);
            }
            String service = ServicesInstallerFromConfiguration.fullyQualifiedServiceName(servicePrefix, serviceName);
            ServicesInstallerUtils.appendInPosition(positionedServices, "" + order, service);
        }
    }

    static String fullyQualifiedServiceName(String servicePrefix, String serviceName) {
        StringBuilder buf = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)servicePrefix)) {
            buf.append(servicePrefix);
            if (!servicePrefix.endsWith(".")) {
                buf.append(".");
            }
        }
        buf.append(serviceName);
        return buf.toString();
    }

    @Deprecated
    private static void appendObjectFixtureService(SortedMap<String, SortedSet<String>> positionedServices, IsisConfiguration configuration) {
        DeploymentType explorationDeploymentType;
        if (configuration.getBoolean("isis.exploration-objects") && (explorationDeploymentType = DeploymentType.lookup(configuration.getString("isis.deploymentType"))).isExploring()) {
            ServicesInstallerUtils.appendInPosition(positionedServices, "2147483647", ObjectFixtureService.class.getName());
        }
    }

    public List<Class<?>> getTypes() {
        return ServicesInstallerFromConfiguration.listOf((Class[])new Class[]{List.class});
    }
}

