/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.adapter;

import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ElementSpecificationProvider;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.InstanceAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.Specification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoAdapter
extends InstanceAbstract
implements ObjectAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PojoAdapter.class);
    private static final int INCOMPLETE_COLLECTION = -1;
    private final SpecificationLoader specificationLoader;
    private final AdapterManager objectAdapterLookup;
    private final Localization localization;
    private Object pojo;
    private Oid oid;
    private ResolveState resolveState;
    private ElementSpecificationProvider elementSpecificationProvider;
    private AuthenticationSession authenticationSession;

    public PojoAdapter(Object pojo, Oid oid, SpecificationLoader specificationLoader, AdapterManager adapterManager, Localization localization, AuthenticationSession authenticationSession) {
        this.specificationLoader = specificationLoader;
        this.objectAdapterLookup = adapterManager;
        this.localization = localization;
        this.authenticationSession = authenticationSession;
        if (pojo instanceof ObjectAdapter) {
            throw new IsisException("Adapter can't be used to adapt an adapter: " + pojo);
        }
        this.pojo = pojo;
        this.oid = oid;
        this.resolveState = ResolveState.NEW;
    }

    protected ObjectSpecification loadSpecification() {
        ObjectSpecification specification = this.specificationLoader.loadSpecification(this.getObject().getClass());
        return specification;
    }

    public ObjectSpecification getSpecification() {
        return (ObjectSpecification)super.getSpecification();
    }

    public Object getObject() {
        return this.pojo;
    }

    public void replacePojo(Object pojo) {
        this.pojo = pojo;
    }

    public ResolveState getResolveState() {
        return this.aggregateResolveState();
    }

    private ResolveState aggregateResolveState() {
        return this.isAggregated() ? ((PojoAdapter)this.getAggregateRoot()).aggregateResolveState() : this.resolveState;
    }

    public void changeState(ResolveState newState) {
        if (this.isAggregated()) {
            return;
        }
        boolean validToChangeTo = this.resolveState.isValidToChangeTo(newState);
        Assert.assertTrue((String)("oid= " + this.getOid() + "; can't change from " + this.resolveState.name() + " to " + newState.name()), (boolean)validToChangeTo);
        if (LOG.isTraceEnabled()) {
            String oidString = this.oid == null ? "" : "for " + this.getOid() + " ";
            LOG.trace(oidString + "changing resolved state to " + newState.name());
        }
        this.resolveState = newState;
    }

    private boolean elementsLoaded() {
        return this.isTransient() || this.isResolved();
    }

    public boolean representsPersistent() {
        return this.aggregateResolveState().representsPersistent();
    }

    public boolean isTransient() {
        return this.aggregateResolveState().isTransient();
    }

    public boolean isNew() {
        return this.aggregateResolveState().isNew();
    }

    public boolean isResolving() {
        return this.aggregateResolveState().isResolving();
    }

    public boolean isResolved() {
        return this.aggregateResolveState().isResolved();
    }

    public boolean isGhost() {
        return this.aggregateResolveState().isGhost();
    }

    public boolean isUpdating() {
        return this.aggregateResolveState().isUpdating();
    }

    public boolean isDestroyed() {
        return this.aggregateResolveState().isDestroyed();
    }

    public boolean canTransitionToResolving() {
        return this.aggregateResolveState().canTransitionToResolving();
    }

    public void markAsResolvedIfPossible() {
        if (!this.canTransitionToResolving()) {
            return;
        }
        this.changeState(ResolveState.RESOLVING);
        this.changeState(ResolveState.RESOLVED);
    }

    public Oid getOid() {
        return this.oid;
    }

    public void replaceOid(Oid persistedOid) {
        Ensure.ensureThatArg((Object)this.oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.oid = persistedOid;
    }

    public boolean isParented() {
        return this.oid instanceof ParentedOid;
    }

    public boolean isAggregated() {
        return this.oid instanceof AggregatedOid;
    }

    public boolean isValue() {
        return this.oid == null;
    }

    public ObjectAdapter getAggregateRoot() {
        if (!this.isParented()) {
            return this;
        }
        ParentedOid parentedOid = (ParentedOid)this.oid;
        TypedOid parentOid = parentedOid.getParentOid();
        ObjectAdapter parentAdapter = this.objectAdapterLookup.getAdapterFor((Oid)parentOid);
        if (parentAdapter == null) {
            Oid parentOidNowPersisted = this.getPersistenceSession().remappedFrom((Oid)parentOid);
            parentAdapter = this.objectAdapterLookup.getAdapterFor(parentOidNowPersisted);
        }
        return parentAdapter;
    }

    public Version getVersion() {
        if (this.isParented()) {
            return this.getAggregateRoot().getVersion();
        }
        return this.getOid().getVersion();
    }

    public void checkLock(Version otherVersion) {
        if (this.isParented()) {
            this.getAggregateRoot().checkLock(otherVersion);
            return;
        }
        Oid thisOid = this.getOid();
        Version thisVersion = thisOid.getVersion();
        if (thisVersion != null && otherVersion != null && thisVersion.different(otherVersion)) {
            if (AdapterManager.ConcurrencyChecking.isCurrentlyEnabled()) {
                LOG.info("concurrency conflict detected on " + thisOid + " (" + otherVersion + ")");
                String currentUser = this.getAuthenticationSession().getUserName();
                throw new ConcurrencyException(currentUser, thisOid, thisVersion, otherVersion);
            }
            LOG.warn("concurrency conflict detected but suppressed, on " + thisOid + " (" + otherVersion + ")");
        }
    }

    public void setVersion(Version version) {
        if (this.isParented()) {
            return;
        }
        if (this.shouldSetVersion(version)) {
            RootOid rootOid = (RootOid)this.getOid();
            rootOid.setVersion(version);
        }
    }

    private boolean shouldSetVersion(Version otherVersion) {
        Version version = this.getOid().getVersion();
        return version == null || otherVersion == null || otherVersion.different(version);
    }

    public String titleString() {
        return this.titleString(null);
    }

    public String titleString(ObjectAdapter contextAdapterIfAny) {
        if (this.getSpecification().isParentedOrFreeCollection()) {
            CollectionFacet facet = (CollectionFacet)this.getSpecification().getFacet(CollectionFacet.class);
            return this.collectionTitleString(facet);
        }
        return this.objectTitleString(contextAdapterIfAny);
    }

    private String objectTitleString(ObjectAdapter contextAdapterIfAny) {
        if (this.isNew()) {
            return "";
        }
        if (this.getObject() instanceof String) {
            return (String)this.getObject();
        }
        ObjectSpecification specification = this.getSpecification();
        String title = specification.getTitle(contextAdapterIfAny, (ObjectAdapter)this, this.localization);
        if (title == null) {
            title = this.getDefaultTitle();
        }
        return title;
    }

    private String collectionTitleString(CollectionFacet facet) {
        int size = this.elementsLoaded() ? facet.size((ObjectAdapter)this) : -1;
        ObjectSpecification elementSpecification = this.getElementSpecification();
        if (elementSpecification == null || elementSpecification.getFullIdentifier().equals(Object.class.getName())) {
            switch (size) {
                case -1: {
                    return "Objects";
                }
                case 0: {
                    return "No objects";
                }
                case 1: {
                    return "1 object";
                }
            }
            return size + " objects";
        }
        switch (size) {
            case -1: {
                return elementSpecification.getPluralName();
            }
            case 0: {
                return "No " + elementSpecification.getPluralName();
            }
            case 1: {
                return "1 " + elementSpecification.getSingularName();
            }
        }
        return size + " " + elementSpecification.getPluralName();
    }

    public synchronized String toString() {
        ToString str = new ToString((Object)this);
        this.toString(str);
        str.append("pojo-toString", this.pojo.toString());
        str.appendAsHex("pojo-hash", (long)this.pojo.hashCode());
        return str.toString();
    }

    protected String getDefaultTitle() {
        return "A" + (" " + this.getSpecification().getSingularName()).toLowerCase();
    }

    protected void toString(ToString str) {
        str.append(this.aggregateResolveState().code());
        Oid oid = this.getOid();
        if (oid != null) {
            str.append(":");
            str.append(oid.toString());
        } else {
            str.append(":-");
        }
        str.setAddComma();
        if (this.getSpecificationNoLoad() == null) {
            str.append("class", this.getObject().getClass().getName());
        } else {
            str.append("specification", this.getSpecification().getShortIdentifier());
        }
        if (this.getOid() != null) {
            Version version = this.getOid().getVersion();
            str.append("version", version != null ? version.sequence() : null);
        }
    }

    public String getIconName() {
        return this.getSpecification().getIconName((ObjectAdapter)this);
    }

    public ObjectSpecification getElementSpecification() {
        if (this.elementSpecificationProvider == null) {
            return null;
        }
        return this.elementSpecificationProvider.getElementType();
    }

    public void setElementSpecificationProvider(ElementSpecificationProvider elementSpecificationProvider) {
        this.elementSpecificationProvider = elementSpecificationProvider;
    }

    public Instance getInstance(Specification specification) {
        throw new UnsupportedOperationException();
    }

    public boolean respondToChangesInPersistentObjects() {
        return this.aggregateResolveState().respondToChangesInPersistentObjects();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }
}

