/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixtures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.fixtures.CompositeFixture;
import org.apache.isis.applib.fixtures.FixtureType;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.runtime.fixtures.SwitchUserServiceImpl;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FixturesInstallerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(FixturesInstallerDelegate.class);
    protected final List<Object> fixtures = new ArrayList<Object>();
    private final SwitchUserServiceImpl switchUserService = new SwitchUserServiceImpl();
    private final PersistenceSession persistenceSession;
    private LogonFixture logonFixture;

    public FixturesInstallerDelegate() {
        this(null);
    }

    public FixturesInstallerDelegate(PersistenceSession persistenceSession) {
        this.persistenceSession = persistenceSession;
    }

    public void addFixture(Object fixture) {
        if (fixture instanceof List) {
            List fixtureList = ObjectExtensions.asListT((Object)fixture, Object.class);
            for (Object eachFixture : fixtureList) {
                this.addFixture(eachFixture);
            }
        } else {
            this.fixtures.add(fixture);
        }
    }

    protected List<Object> getFixtures() {
        return Collections.unmodifiableList(this.fixtures);
    }

    public void clearFixtures() {
        this.fixtures.clear();
    }

    public final void installFixtures() {
        this.preInstallFixtures(this.getPersistenceSession());
        this.installFixtures(this.getFixtures());
        this.postInstallFixtures(this.getPersistenceSession());
    }

    protected void preInstallFixtures(PersistenceSession persistenceSession) {
    }

    private void installFixtures(List<Object> fixtures) {
        for (Object fixture : fixtures) {
            this.installFixtureInTransaction(fixture);
        }
    }

    private void installFixtureInTransaction(Object fixture) {
        this.getServicesInjector().injectServicesInto(fixture);
        this.installFixtures(this.getFixtures(fixture));
        try {
            LOG.info("installing fixture: " + fixture);
            this.getTransactionManager().startTransaction();
            this.installFixture(fixture);
            this.saveLogonFixtureIfRequired(fixture);
            this.getTransactionManager().endTransaction();
            LOG.info("fixture installed");
        }
        catch (RuntimeException e) {
            LOG.error("installing fixture " + fixture.getClass().getName() + " failed; aborting ", (Throwable)e);
            try {
                this.getTransactionManager().abortTransaction();
            }
            catch (Exception e2) {
                LOG.error("failure during abort", (Throwable)e2);
            }
            throw e;
        }
    }

    private List<Object> getFixtures(Object fixture) {
        if (fixture instanceof CompositeFixture) {
            CompositeFixture compositeFixture = (CompositeFixture)fixture;
            return compositeFixture.getFixtures();
        }
        return Collections.emptyList();
    }

    private void installFixture(Object fixture) {
        InstallableFixture installableFixture;
        this.switchUserService.injectInto(fixture);
        if (fixture instanceof InstallableFixture && this.shouldInstallFixture(installableFixture = (InstallableFixture)fixture)) {
            installableFixture.install();
        }
        if (fixture instanceof LogonFixture) {
            this.logonFixture = (LogonFixture)fixture;
        }
    }

    private boolean shouldInstallFixture(InstallableFixture installableFixture) {
        FixtureType fixtureType = installableFixture.getType();
        if (fixtureType == FixtureType.DOMAIN_OBJECTS) {
            return !IsisContext.getPersistenceSession().isFixturesInstalled();
        }
        return true;
    }

    private void saveLogonFixtureIfRequired(Object fixture) {
        if (fixture instanceof LogonFixture) {
            if (this.logonFixture != null) {
                LOG.warn("Already specified logon fixture, using latest provided");
            }
            this.logonFixture = (LogonFixture)fixture;
        }
    }

    protected void postInstallFixtures(PersistenceSession persistenceSession) {
    }

    public LogonFixture getLogonFixture() {
        return this.logonFixture;
    }

    private PersistenceSession getPersistenceSession() {
        return this.persistenceSession != null ? this.persistenceSession : IsisContext.getPersistenceSession();
    }

    private ServicesInjectorSpi getServicesInjector() {
        return this.getPersistenceSession().getServicesInjector();
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }
}

