/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.progmodels.dflt;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.FacetDecoratorInstaller;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.metamodel.specloader.ReflectorConstants;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.progmodels.dflt.JavaReflectorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaReflectorInstallerNoDecorators
extends InstallerAbstract
implements ObjectReflectorInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(JavaReflectorInstallerNoDecorators.class);
    public static final String PROPERTY_BASE = "isis.";
    protected final LinkedHashSet<FacetDecoratorInstaller> decoratorInstallers = Sets.newLinkedHashSet();

    public JavaReflectorInstallerNoDecorators() {
        this("java");
    }

    public JavaReflectorInstallerNoDecorators(String name) {
        super("reflector", name);
    }

    @Override
    public SpecificationLoaderSpi createReflector(Collection<MetaModelRefiner> metaModelRefiners) {
        ProgrammingModel programmingModel = this.createProgrammingModel(this.getConfiguration());
        Set<FacetDecorator> facetDecorators = this.createFacetDecorators(this.getConfiguration());
        MetaModelValidator mmv = this.createMetaModelValidator(this.getConfiguration());
        List<LayoutMetadataReader> layoutMetadataReaders = this.createLayoutMetadataReaders(this.getConfiguration());
        return JavaReflectorHelper.createObjectReflector(programmingModel, metaModelRefiners, facetDecorators, layoutMetadataReaders, mmv, this.getConfiguration());
    }

    protected ProgrammingModel createProgrammingModel(IsisConfiguration configuration) {
        ProgrammingModel programmingModel = this.lookupAndCreateProgrammingModelFacets(configuration);
        this.includeAndExcludeFacetFactories(configuration, programmingModel);
        return programmingModel;
    }

    private ProgrammingModel lookupAndCreateProgrammingModelFacets(IsisConfiguration configuration) {
        String progModelFacetsClassName = configuration.getString("isis.reflector.facets", ReflectorConstants.PROGRAMMING_MODEL_FACETS_CLASS_NAME_DEFAULT);
        ProgrammingModel programmingModel = InstanceUtil.createInstance(progModelFacetsClassName, ProgrammingModel.class);
        return programmingModel;
    }

    private void includeAndExcludeFacetFactories(IsisConfiguration configuration, ProgrammingModel programmingModel) {
        this.includeFacetFactories(configuration, programmingModel);
        this.excludeFacetFactories(configuration, programmingModel);
    }

    protected void includeFacetFactories(IsisConfiguration configuration, ProgrammingModel programmingModel) {
        ProgrammingModel.Util.includeFacetFactories(configuration, programmingModel);
    }

    protected void excludeFacetFactories(IsisConfiguration configuration, ProgrammingModel programmingModel) {
        ProgrammingModel.Util.excludeFacetFactories(configuration, programmingModel);
    }

    protected Set<FacetDecorator> createFacetDecorators(IsisConfiguration configuration) {
        return Collections.emptySet();
    }

    protected MetaModelValidator createMetaModelValidator(IsisConfiguration configuration) {
        String metaModelValidatorClassName = configuration.getString("isis.reflector.validator", ReflectorConstants.META_MODEL_VALIDATOR_CLASS_NAME_DEFAULT);
        return InstanceUtil.createInstance(metaModelValidatorClassName, MetaModelValidator.class);
    }

    protected List<LayoutMetadataReader> createLayoutMetadataReaders(IsisConfiguration configuration) {
        ArrayList layoutMetadataReaders = Lists.newArrayList();
        String[] layoutMetadataReaderClassNames = configuration.getList("isis.reflector.layoutMetadataReaders", ReflectorConstants.LAYOUT_METADATA_READER_LIST_DEFAULT);
        if (layoutMetadataReaderClassNames != null) {
            for (String layoutMetadataReaderClassName : layoutMetadataReaderClassNames) {
                LayoutMetadataReader layoutMetadataReader = InstanceUtil.createInstance(layoutMetadataReaderClassName, LayoutMetadataReader.class);
                layoutMetadataReaders.add(layoutMetadataReader);
            }
        }
        return layoutMetadataReaders;
    }

    @Override
    public void addFacetDecoratorInstaller(FacetDecoratorInstaller decoratorInstaller) {
        if (decoratorInstaller == null) {
            return;
        }
        this.decoratorInstallers.add(decoratorInstaller);
    }

    @Override
    public List<Class<?>> getTypes() {
        return JavaReflectorInstallerNoDecorators.listOf(SpecificationLoaderSpi.class);
    }
}

