/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.query;

import javax.jdo.annotations.Query;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public final class JdoNamedQuery {
    private final String name;
    private final String query;
    private final ObjectSpecification objSpec;

    public JdoNamedQuery(String name, String query, ObjectSpecification noSpec) {
        Ensure.ensureThatArg(name, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(query, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(noSpec, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.name = name;
        this.query = query;
        this.objSpec = noSpec;
    }

    public JdoNamedQuery(Query jdoNamedQuery, ObjectSpecification objSpec) {
        this(jdoNamedQuery.name(), jdoNamedQuery.value(), objSpec);
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public ObjectSpecification getObjectSpecification() {
        return this.objSpec;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JdoNamedQuery other = (JdoNamedQuery)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

