/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.config;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.commons.resource.ResourceStreamSourceAbstract;

public class ResourceStreamSourceForWebInf
extends ResourceStreamSourceAbstract {
    public static final String DEFAULT_WEBINF_DIRECTORY = "/WEB-INF";
    private final ServletContext servletContext;
    private final String configurationDirectory;

    public ResourceStreamSourceForWebInf(ServletContext servletContext) {
        this(servletContext, DEFAULT_WEBINF_DIRECTORY);
    }

    public ResourceStreamSourceForWebInf(ServletContext servletContext, String configurationDirectory) {
        this.servletContext = servletContext;
        this.configurationDirectory = configurationDirectory;
    }

    @Override
    public String getName() {
        return "servlet context ('" + this.configurationDirectory + "')";
    }

    @Override
    public InputStream doReadResource(String resourcePath) throws IOException {
        String fullyQualifiedResourcePath = StringExtensions.combinePath(this.configurationDirectory, resourcePath);
        return this.servletContext.getResourceAsStream(fullyQualifiedResourcePath);
    }
}

