/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl.dflt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.all.i18n.NamedFacetTranslated;
import org.apache.isis.core.metamodel.facets.all.i18n.PluralFacetTranslated;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.facets.object.plural.inferred.PluralFacetInferred;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.object.wizard.WizardFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectInstantiationException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.SpecificationContext;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.specimpl.CreateObjectContext;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilder;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneAssociationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSpecificationDefault
extends ObjectSpecificationAbstract
implements DebuggableWithTitle,
FacetHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectSpecificationDefault.class);
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();
    private boolean isService;
    private Map<Method, ObjectMember> membersByMethod = null;
    private final CreateObjectContext createObjectContext;
    private final FacetedMethodsBuilder facetedMethodsBuilder;

    private static String determineShortName(Class<?> introspectedClass) {
        String name = introspectedClass.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public ObjectSpecificationDefault(Class<?> correspondingClass, FacetedMethodsBuilderContext facetedMethodsBuilderContext, SpecificationContext specContext, ObjectMemberContext objectMemberContext, CreateObjectContext createObjectContext) {
        super(correspondingClass, ObjectSpecificationDefault.determineShortName(correspondingClass), specContext, objectMemberContext);
        this.facetedMethodsBuilder = new FacetedMethodsBuilder(this, facetedMethodsBuilderContext);
        this.createObjectContext = createObjectContext;
    }

    @Override
    public void introspectTypeHierarchyAndMembers() {
        this.metadataProperties = null;
        if (this.isNotIntrospected()) {
            this.metadataProperties = this.facetedMethodsBuilder.introspectClass();
        }
        if (this.isNotIntrospected()) {
            this.addNamedFacetAndPluralFacetIfRequired();
        }
        if (this.containsFacet(ValueFacet.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skipping full introspection for value type " + this.getFullIdentifier());
            }
            return;
        }
        if (this.isNotIntrospected()) {
            Class<?> superclass = this.getCorrespondingClass().getSuperclass();
            this.updateSuperclass(superclass);
        }
        Class<?>[] interfaceTypes = this.getCorrespondingClass().getInterfaces();
        ArrayList interfaceSpecList = Lists.newArrayList();
        for (Class<?> interfaceType : interfaceTypes) {
            Class<?> substitutedInterfaceType = this.classSubstitutor.getClass(interfaceType);
            if (substitutedInterfaceType == null) continue;
            ObjectSpecification interfaceSpec = this.getSpecificationLoader().loadSpecification(substitutedInterfaceType);
            interfaceSpecList.add(interfaceSpec);
        }
        if (this.isNotIntrospected()) {
            this.updateAsSubclassTo(interfaceSpecList);
        }
        if (this.isNotIntrospected()) {
            this.updateInterfaces(interfaceSpecList);
        }
        if (this.isNotIntrospected()) {
            List<ObjectAssociation> associations = this.createAssociations(this.metadataProperties);
            this.sortAndUpdateAssociations(associations);
        }
        if (this.isNotIntrospected()) {
            List<ObjectAction> actions = this.createActions(this.metadataProperties);
            this.sortCacheAndUpdateActions(actions);
        }
        if (this.isNotIntrospected()) {
            this.facetedMethodsBuilder.introspectClassPostProcessing(this.metadataProperties);
        }
        if (this.isNotIntrospected()) {
            this.updateFromFacetValues();
        }
    }

    private void addNamedFacetAndPluralFacetIfRequired() {
        PluralFacet pluralFacet;
        NamedFacet namedFacet = this.getFacet(NamedFacet.class);
        if (namedFacet == null) {
            namedFacet = new NamedFacetInferred(StringExtensions.asNaturalName2(this.getShortIdentifier()), (FacetHolder)this);
            this.addFacet(namedFacet);
        }
        if ((pluralFacet = this.getFacet(PluralFacet.class)) == null) {
            if (namedFacet instanceof NamedFacetTranslated) {
                NamedFacetTranslated facet = (NamedFacetTranslated)namedFacet;
                pluralFacet = new PluralFacetTranslated(facet, this);
            } else {
                pluralFacet = new PluralFacetInferred(StringExtensions.asPluralName(namedFacet.value()), this);
            }
            this.addFacet(pluralFacet);
        }
    }

    private List<ObjectAssociation> createAssociations(Properties properties) {
        List<FacetedMethod> associationFacetedMethods = this.facetedMethodsBuilder.getAssociationFacetedMethods(properties);
        ArrayList associations = Lists.newArrayList();
        for (FacetedMethod facetedMethod : associationFacetedMethods) {
            ObjectAssociation association = this.createAssociation(facetedMethod);
            if (association == null) continue;
            associations.add(association);
        }
        return associations;
    }

    private ObjectAssociation createAssociation(FacetedMethod facetMethod) {
        if (facetMethod.getFeatureType().isCollection()) {
            return new OneToManyAssociationImpl(facetMethod, this.objectMemberContext);
        }
        if (facetMethod.getFeatureType().isProperty()) {
            return new OneToOneAssociationImpl(facetMethod, this.objectMemberContext);
        }
        return null;
    }

    private List<ObjectAction> createActions(Properties metadataProperties) {
        List<FacetedMethod> actionFacetedMethods = this.facetedMethodsBuilder.getActionFacetedMethods(metadataProperties);
        ArrayList actions = Lists.newArrayList();
        for (FacetedMethod facetedMethod : actionFacetedMethods) {
            ObjectAction action = this.createAction(facetedMethod);
            if (action == null) continue;
            actions.add(action);
        }
        return actions;
    }

    private ObjectAction createAction(FacetedMethod facetedMethod) {
        if (facetedMethod.getFeatureType().isAction()) {
            return new ObjectActionImpl(facetedMethod, this.objectMemberContext);
        }
        return null;
    }

    @Override
    public boolean isService() {
        return this.isService;
    }

    @Override
    public void markAsService() {
        this.ensureServiceHasNoAssociations();
        this.isService = true;
    }

    private void ensureServiceHasNoAssociations() {
        List<ObjectAssociation> associations = this.getAssociations(Contributed.EXCLUDED);
        StringBuilder buf = new StringBuilder();
        for (ObjectAssociation association : associations) {
            String name = association.getId();
            if (this.isValidAssociationForService(name)) continue;
            this.appendAssociationName(buf, name);
        }
        if (buf.length() > 0) {
            throw new ObjectSpecificationException("Service object " + this.getFullIdentifier() + " should have no fields, but has: " + buf);
        }
    }

    private boolean isValidAssociationForService(String associationId) {
        return "id".indexOf(associationId) != -1;
    }

    private void appendAssociationName(StringBuilder fieldNames, String name) {
        fieldNames.append(fieldNames.length() > 0 ? ", " : "");
        fieldNames.append(name);
    }

    @Override
    public boolean isViewModel() {
        return this.containsFacet(ViewModelFacet.class);
    }

    @Override
    public boolean isViewModelCloneable(ObjectAdapter targetAdapter) {
        ViewModelFacet facet = this.getFacet(ViewModelFacet.class);
        if (facet == null) {
            return false;
        }
        Object pojo = targetAdapter.getObject();
        return facet.isCloneable(pojo);
    }

    @Override
    public boolean isWizard() {
        return this.containsFacet(WizardFacet.class);
    }

    @Override
    public ObjectAction getObjectAction(ActionType type, String id, List<ObjectSpecification> parameters) {
        List<ObjectAction> actions = this.getObjectActions(type, Contributed.INCLUDED, (Filter<ObjectAction>)Filters.any());
        return ObjectSpecificationDefault.firstAction(actions, id, parameters);
    }

    @Override
    public ObjectAction getObjectAction(ActionType type, String id) {
        List<ObjectAction> actions = this.getObjectActions(type, Contributed.INCLUDED, (Filter<ObjectAction>)Filters.any());
        return ObjectSpecificationDefault.firstAction(actions, id);
    }

    @Override
    public ObjectAction getObjectAction(String id) {
        List<ObjectAction> actions = this.getObjectActions(ActionType.ALL, Contributed.INCLUDED, (Filter<ObjectAction>)Filters.any());
        return ObjectSpecificationDefault.firstAction(actions, id);
    }

    private static ObjectAction firstAction(List<ObjectAction> candidateActions, String actionName, List<ObjectSpecification> parameters) {
        block0: for (int i = 0; i < candidateActions.size(); ++i) {
            ObjectAction action = candidateActions.get(i);
            if (actionName != null && !actionName.equals(action.getId()) || action.getParameters().size() != parameters.size()) continue;
            for (int j = 0; j < parameters.size(); ++j) {
                if (!parameters.get(j).isOfType(action.getParameters().get(j).getSpecification())) continue block0;
            }
            return action;
        }
        return null;
    }

    private static ObjectAction firstAction(List<ObjectAction> candidateActions, String id) {
        if (id == null) {
            return null;
        }
        for (int i = 0; i < candidateActions.size(); ++i) {
            ObjectAction action = candidateActions.get(i);
            if (id.equals(action.getIdentifier().toNameParmsIdentityString())) {
                return action;
            }
            if (!id.equals(action.getIdentifier().toNameIdentityString())) continue;
            return action;
        }
        return null;
    }

    @Override
    public Object createObject() {
        if (this.getCorrespondingClass().isArray()) {
            return Array.newInstance(this.getCorrespondingClass().getComponentType(), 0);
        }
        try {
            return this.getObjectInstantiator().instantiate(this.getCorrespondingClass());
        }
        catch (ObjectInstantiationException e) {
            throw new IsisException("Failed to create instance of type " + this.getFullIdentifier(), e);
        }
    }

    @Override
    public ObjectAdapter initialize(ObjectAdapter adapter) {
        List<ObjectAssociation> fields = adapter.getSpecification().getAssociations(Contributed.EXCLUDED);
        for (ObjectAssociation field : fields) {
            field.toDefault(adapter);
        }
        this.getDependencyInjector().injectServicesInto(adapter.getObject());
        CallbackFacet.Util.callCallback(adapter, CreatedCallbackFacet.class);
        return adapter;
    }

    public ObjectMember getMember(Method method) {
        if (this.membersByMethod == null) {
            this.membersByMethod = this.catalogueMembers();
        }
        return this.membersByMethod.get(method);
    }

    private HashMap<Method, ObjectMember> catalogueMembers() {
        HashMap membersByMethod = Maps.newHashMap();
        this.cataloguePropertiesAndCollections(membersByMethod);
        this.catalogueActions(membersByMethod);
        return membersByMethod;
    }

    private void cataloguePropertiesAndCollections(Map<Method, ObjectMember> membersByMethod) {
        Filter noop = Filters.anyOfType(ObjectAssociation.class);
        List<ObjectAssociation> fields = this.getAssociations(Contributed.EXCLUDED, (Filter<ObjectAssociation>)noop);
        for (int i = 0; i < fields.size(); ++i) {
            ObjectAssociation field = fields.get(i);
            List<Facet> facets = field.getFacets(ImperativeFacet.FILTER);
            for (Facet facet : facets) {
                ImperativeFacet imperativeFacet = ImperativeFacet.Util.getImperativeFacet(facet);
                for (Method imperativeFacetMethod : imperativeFacet.getMethods()) {
                    membersByMethod.put(imperativeFacetMethod, field);
                }
            }
        }
    }

    private void catalogueActions(Map<Method, ObjectMember> membersByMethod) {
        List<ObjectAction> userActions = this.getObjectActions(Contributed.INCLUDED);
        for (int i = 0; i < userActions.size(); ++i) {
            ObjectAction userAction = userActions.get(i);
            List<Facet> facets = userAction.getFacets(ImperativeFacet.FILTER);
            for (Facet facet : facets) {
                ImperativeFacet imperativeFacet = ImperativeFacet.Util.getImperativeFacet(facet);
                for (Method imperativeFacetMethod : imperativeFacet.getMethods()) {
                    membersByMethod.put(imperativeFacetMethod, userAction);
                }
            }
        }
    }

    @Override
    public void debugData(DebugBuilder debug) {
        debug.blankLine();
        debug.appendln("Title", this.getFacet(TitleFacet.class));
        IconFacet iconFacet = this.getFacet(IconFacet.class);
        if (iconFacet != null) {
            debug.appendln("Icon", iconFacet);
        }
        debug.unindent();
    }

    @Override
    public String debugTitle() {
        return "NO Member Specification";
    }

    @Override
    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.getFullIdentifier());
        str.append("type", this.isParentedOrFreeCollection() ? "Collection" : "Object");
        str.append("persistable", (Object)this.persistability());
        str.append("superclass", this.superclass() == null ? "Object" : this.superclass().getFullIdentifier());
        return str.toString();
    }

    protected ServicesInjector getDependencyInjector() {
        return this.createObjectContext.getDependencyInjector();
    }
}

