/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetAbstract;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetForContributee;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacetAbstract;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionImpl;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyAssociationImpl;

public class OneToManyAssociationContributee
extends OneToManyAssociationImpl
implements ContributeeMember {
    private final ObjectAdapter serviceAdapter;
    private final ObjectAction serviceAction;
    private final FacetHolder facetHolder = new FacetHolderImpl();
    private final Identifier identifier;

    private static ObjectSpecification typeOfSpec(ObjectActionImpl objectAction, ObjectMemberContext objectMemberContext) {
        TypeOfFacet actionTypeOfFacet = objectAction.getFacet(TypeOfFacet.class);
        SpecificationLoader specificationLookup = objectMemberContext.getSpecificationLoader();
        Class cls = actionTypeOfFacet != null ? actionTypeOfFacet.value() : Object.class;
        return specificationLookup.loadSpecification(cls);
    }

    public OneToManyAssociationContributee(ObjectAdapter serviceAdapter, ObjectActionImpl serviceAction, ObjectSpecification contributeeType, ObjectMemberContext objectMemberContext) {
        super(serviceAction.getFacetedMethod(), OneToManyAssociationContributee.typeOfSpec(serviceAction, objectMemberContext), objectMemberContext);
        this.serviceAdapter = serviceAdapter;
        this.serviceAction = serviceAction;
        NotPersistedFacetAbstract notPersistedFacet = new NotPersistedFacetAbstract((FacetHolder)this){};
        DisabledFacet disabledFacet = this.disabledFacet();
        TypeOfFacetAbstract typeOfFacet = new TypeOfFacetAbstract(this.getSpecification().getCorrespondingClass(), this, objectMemberContext.getSpecificationLoader()){};
        FacetUtil.addFacet(notPersistedFacet);
        FacetUtil.addFacet(disabledFacet);
        FacetUtil.addFacet(typeOfFacet);
        FacetUtil.copyFacets(serviceAction.getFacetedMethod(), this.facetHolder);
        Identifier contributorIdentifier = serviceAction.getFacetedMethod().getIdentifier();
        String memberName = contributorIdentifier.getMemberName();
        List memberParameterNames = contributorIdentifier.getMemberParameterNames();
        this.identifier = Identifier.actionIdentifier((String)contributeeType.getCorrespondingClass().getName(), (String)memberName, (List)memberParameterNames);
    }

    private DisabledFacet disabledFacet() {
        DisabledFacet originalFacet = this.facetHolder.getFacet(DisabledFacet.class);
        if (originalFacet != null && originalFacet.when() == When.ALWAYS && originalFacet.where() == Where.ANYWHERE) {
            return originalFacet;
        }
        return new DisabledFacetForContributee("Contributed collection", this);
    }

    @Override
    public ObjectAdapter get(ObjectAdapter ownerAdapter) {
        return this.serviceAction.execute(this.serviceAdapter, new ObjectAdapter[]{ownerAdapter});
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isContributedBy(ObjectAction serviceAction) {
        return serviceAction == this.serviceAction;
    }

    @Override
    public int getContributeeParamPosition() {
        return 0;
    }

    @Override
    public Consent isVisible(AuthenticationSession session, ObjectAdapter contributee, Where where) {
        VisibilityContext<?> ic = this.serviceAction.createVisibleInteractionContext(session, InteractionInvocationMethod.BY_USER, this.serviceAdapter, where);
        ic.putContributee(0, contributee);
        return InteractionUtils.isVisibleResult(this, ic).createConsent();
    }

    @Override
    public Consent isUsable(AuthenticationSession session, ObjectAdapter contributee, Where where) {
        UsabilityContext<?> ic = this.serviceAction.createUsableInteractionContext(session, InteractionInvocationMethod.BY_USER, this.serviceAdapter, where);
        ic.putContributee(0, contributee);
        return InteractionUtils.isUsableResult(this, ic).createConsent();
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.facetHolder.getFacetTypes();
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.facetHolder.getFacet(cls);
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.facetHolder.containsFacet(facetType);
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        return this.facetHolder.containsDoOpFacet(facetType);
    }

    @Override
    public List<Facet> getFacets(Filter<Facet> filter) {
        return this.facetHolder.getFacets(filter);
    }

    @Override
    public void addFacet(Facet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        this.facetHolder.removeFacet(facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        this.facetHolder.removeFacet(facetType);
    }
}

