/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.collectiontyperegistry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.metamodel.spec.feature.OneToManyFeature;

public class CollectionTypeRegistry {
    private final List<Class<?>> collectionTypes = new ArrayList();
    private Class<?>[] collectionTypesAsArray = new Class[0];

    public CollectionTypeRegistry() {
        this.addCollectionType(Collection.class);
    }

    private void addCollectionType(Class<?> collectionType) {
        this.collectionTypes.add(collectionType);
        this.collectionTypesAsArray = this.collectionTypes.toArray(new Class[0]);
    }

    public boolean isCollectionType(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    public boolean isArrayType(Class<?> cls) {
        return cls.isArray();
    }

    public Class<?>[] getCollectionType() {
        return this.collectionTypesAsArray;
    }

    public OneToManyFeature.CollectionSemantics semanticsOf(Class<?> underlyingClass) {
        if (!Collection.class.isAssignableFrom(underlyingClass)) {
            return OneToManyFeature.CollectionSemantics.ARRAY;
        }
        if (List.class.isAssignableFrom(underlyingClass)) {
            return OneToManyFeature.CollectionSemantics.LIST;
        }
        if (Set.class.isAssignableFrom(underlyingClass)) {
            return OneToManyFeature.CollectionSemantics.SET;
        }
        return OneToManyFeature.CollectionSemantics.OTHER;
    }
}

