/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.classsubstitutor;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.JavassistEnhanced;

public class ClassSubstitutor {
    private final Set<Class<?>> classesToIgnore = Sets.newHashSet();
    private final Set<String> classNamesToIgnore = Sets.newHashSet();

    public ClassSubstitutor() {
        this.ignore(DomainObjectContainer.class);
        this.ignore("net.sf.cglib.proxy.Factory");
        this.ignore("net.sf.cglib.proxy.MethodProxy");
        this.ignore("net.sf.cglib.proxy.Callback");
        this.ignore("javassist.util.proxy.ProxyObject");
        this.ignore("javassist.util.proxy.MethodHandler");
    }

    public Class<?> getClass(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (cls.getName().startsWith("org.datanucleus")) {
            return this.getClass(cls.getSuperclass());
        }
        if (this.shouldIgnore(cls)) {
            return null;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null && superclass.isEnum()) {
            return superclass;
        }
        if (ClassUtil.directlyImplements(cls, JavassistEnhanced.class)) {
            return this.getClass(cls.getSuperclass());
        }
        return cls;
    }

    private boolean ignore(Class<?> q) {
        return this.classesToIgnore.add(q);
    }

    private boolean ignore(String className) {
        return this.classNamesToIgnore.add(className);
    }

    private boolean shouldIgnore(Class<?> cls) {
        if (cls.isArray()) {
            return this.shouldIgnore(cls.getComponentType());
        }
        return this.classesToIgnore.contains(cls) || this.classNamesToIgnore.contains(cls.getCanonicalName());
    }
}

