/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class FreeStandingList
extends AbstractList<ObjectAdapter> {
    private final List<ObjectAdapter> instances;
    private final ObjectSpecification instanceSpecification;

    public FreeStandingList(ObjectSpecification instanceSpecification, List<ObjectAdapter> instances) {
        this.instanceSpecification = instanceSpecification;
        this.instances = Collections.unmodifiableList(instances);
    }

    @Override
    public ObjectAdapter get(int index) {
        return this.instances.get(index);
    }

    @Override
    public int size() {
        return this.instances.size();
    }

    public ObjectSpecification getElementSpecification() {
        return this.instanceSpecification;
    }

    public String titleString() {
        return this.instanceSpecification.getPluralName() + ", " + this.size();
    }

    @Override
    public String toString() {
        String title;
        ToString s = new ToString(this);
        s.append("elements", this.instanceSpecification.getFullIdentifier());
        try {
            title = "'" + this.titleString() + "'";
        }
        catch (NullPointerException e) {
            title = "none";
        }
        s.append("title", title);
        s.append("vector", this.instances);
        return s.toString();
    }
}

