/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.metamodel;

import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class MetaModelServiceDefault
implements MetaModelService,
SpecificationLoaderAware {
    private static final Logger LOG = LoggerFactory.getLogger(MetaModelServiceDefault.class);
    private SpecificationLoader specificationLookup;

    @Programmatic
    public Class<?> fromObjectType(String objectType) {
        if (objectType == null) {
            return null;
        }
        ObjectSpecId objectSpecId = new ObjectSpecId(objectType);
        ObjectSpecification objectSpecification = this.specificationLookup.lookupBySpecId(objectSpecId);
        return objectSpecification != null ? objectSpecification.getCorrespondingClass() : null;
    }

    public String toObjectType(Class<?> domainType) {
        if (domainType == null) {
            return null;
        }
        ObjectSpecification objectSpecification = this.specificationLookup.loadSpecification(domainType);
        ObjectSpecIdFacet objectSpecIdFacet = objectSpecification.getFacet(ObjectSpecIdFacet.class);
        ObjectSpecId objectSpecId = objectSpecIdFacet.value();
        return objectSpecId.asString();
    }

    @Override
    public void setSpecificationLoader(SpecificationLoader specificationLookup) {
        this.specificationLookup = specificationLookup;
    }
}

