/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.bookmarks;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkHolder;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.metamodel.adapter.DomainObjectServices;
import org.apache.isis.core.metamodel.adapter.DomainObjectServicesAware;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;

@DomainService(nature=NatureOfService.DOMAIN)
public class BookmarkServiceDefault
implements BookmarkService,
DomainObjectServicesAware {
    private DomainObjectServices domainObjectServices;
    @Inject
    private WrapperFactory wrapperFactory;

    @Programmatic
    public Object lookup(BookmarkHolder bookmarkHolder) {
        Bookmark bookmark = bookmarkHolder.bookmark();
        return bookmark != null ? this.lookup(bookmark) : null;
    }

    @Programmatic
    public Object lookup(Bookmark bookmark) {
        if (bookmark == null) {
            return null;
        }
        try {
            return this.domainObjectServices.lookup(bookmark);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    @Programmatic
    public <T> T lookup(Bookmark bookmark, Class<T> cls) {
        return (T)this.lookup(bookmark);
    }

    @Programmatic
    public Bookmark bookmarkFor(Object domainObject) {
        if (domainObject == null) {
            return null;
        }
        return this.domainObjectServices.bookmarkFor(this.unwrapped(domainObject));
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    @Programmatic
    public Bookmark bookmarkFor(Class<?> cls, String identifier) {
        return this.domainObjectServices.bookmarkFor(cls, identifier);
    }

    @Override
    @Programmatic
    public void setDomainObjectServices(DomainObjectServices domainObjectServices) {
        this.domainObjectServices = domainObjectServices;
    }
}

