/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.InjectorMethodEvaluator;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;
import org.apache.isis.core.metamodel.specloader.InjectorMethodEvaluatorDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInjectorDefault
implements ServicesInjectorSpi,
SpecificationLoaderAware {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInjectorDefault.class);
    private final List<Object> services = Lists.newArrayList();
    private final Map<Class<?>, List<Object>> servicesAssignableToType = Maps.newHashMap();
    private final Map<Class<?>, Object> serviceByConcreteType = Maps.newHashMap();
    private InjectorMethodEvaluator injectorMethodEvaluator;

    public ServicesInjectorDefault(List<Object> services) {
        this(services, null);
    }

    public ServicesInjectorDefault(List<Object> services, InjectorMethodEvaluator injectorMethodEvaluator) {
        this.services.addAll(services);
        this.injectorMethodEvaluator = injectorMethodEvaluator != null ? injectorMethodEvaluator : new InjectorMethodEvaluatorDefault();
        this.autowireServicesAndContainer();
    }

    @Override
    public void init() {
        this.autowireServicesAndContainer();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public <T> void replaceService(T existingService, T replacementService) {
        if (!this.services.remove(existingService)) {
            throw new IllegalArgumentException("Service to be replaced was not found (" + existingService + ")");
        }
        this.services.add(replacementService);
        this.servicesAssignableToType.clear();
        this.serviceByConcreteType.clear();
        this.autowireServicesAndContainer();
    }

    @Override
    public boolean isRegisteredService(Class<?> cls) {
        if (this.serviceByConcreteType.isEmpty()) {
            for (Object service : this.services) {
                Class<?> concreteType = service.getClass();
                this.serviceByConcreteType.put(concreteType, service);
            }
        }
        return this.serviceByConcreteType.containsKey(cls);
    }

    @Override
    public <T> void addFallbackIfRequired(Class<T> serviceClass, T serviceInstance) {
        if (!ServicesInjectorDefault.contains(this.services, serviceClass)) {
            this.services.add(0, serviceInstance);
        }
    }

    @Override
    public void validateServices() {
        ServicesInjectorDefault.validate(this.getRegisteredServices());
    }

    private static void validate(List<Object> serviceList) {
        for (Object service : serviceList) {
            Method[] methodArray;
            for (Method method : methodArray = service.getClass().getMethods()) {
                ServicesInjectorDefault.validatePostConstructMethods(service, method);
                ServicesInjectorDefault.validatePreDestroyMethods(service, method);
            }
        }
        ArrayListMultimap servicesById = ArrayListMultimap.create();
        for (Object object : serviceList) {
            String id = ServiceUtil.id(object);
            servicesById.put((Object)id, object);
        }
        for (Map.Entry entry : servicesById.asMap().entrySet()) {
            String serviceId = (String)entry.getKey();
            Collection services = (Collection)entry.getValue();
            if (services.size() <= 1) continue;
            throw new IllegalStateException(String.format("Service ids must be unique; serviceId '%s' is declared by domain services %s", serviceId, ServicesInjectorDefault.classNamesFor(services)));
        }
    }

    private static String classNamesFor(Collection<Object> services) {
        StringBuilder buf = new StringBuilder();
        for (Object service : services) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(service.getClass().getName());
        }
        return buf.toString();
    }

    private static void validatePostConstructMethods(Object service, Method method) {
        PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
        if (postConstruct == null) {
            return;
        }
        int numParams = method.getParameterTypes().length;
        if (numParams == 0) {
            return;
        }
        if (numParams == 1 && method.getParameterTypes()[0].isAssignableFrom(Map.class)) {
            return;
        }
        throw new IllegalStateException("Domain service " + service.getClass().getName() + " has @PostConstruct method " + method.getName() + "; such methods must take either no argument or 1 argument of type Map<String,String>");
    }

    private static void validatePreDestroyMethods(Object service, Method method) {
        PreDestroy preDestroy = method.getAnnotation(PreDestroy.class);
        if (preDestroy == null) {
            return;
        }
        int numParams = method.getParameterTypes().length;
        if (numParams == 0) {
            return;
        }
        throw new IllegalStateException("Domain service " + service.getClass().getName() + " has @PreDestroy method " + method.getName() + "; such methods must take no arguments");
    }

    static boolean contains(List<Object> services, Class<?> serviceClass) {
        for (Object service : services) {
            if (!serviceClass.isAssignableFrom(service.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> getRegisteredServices() {
        return Collections.unmodifiableList(this.services);
    }

    private void addServices(List<Object> services) {
        for (Object service : services) {
            if (service instanceof List) {
                List<Object> serviceList = ObjectExtensions.asListT(service, Object.class);
                this.addServices(serviceList);
                continue;
            }
            this.addService(service);
        }
    }

    private boolean addService(Object service) {
        return this.services.add(service);
    }

    @Override
    public void injectServicesInto(Object object) {
        Assert.assertNotNull("no services", this.services);
        this.injectServices(object, Collections.unmodifiableList(this.services));
    }

    @Override
    public void injectServicesInto(List<Object> objects) {
        for (Object object : objects) {
            this.injectServicesInto(object);
        }
    }

    @Override
    public void injectInto(Object candidate) {
        if (ServicesInjectorAware.class.isAssignableFrom(candidate.getClass())) {
            ServicesInjectorAware cast = (ServicesInjectorAware)ServicesInjectorAware.class.cast(candidate);
            cast.setServicesInjector(this);
        }
    }

    private void injectServices(Object object, List<Object> services) {
        Class<?> cls = object.getClass();
        this.autowireViaFields(object, services, cls);
        this.autowireViaPrefixedMethods(object, services, cls, "set");
        this.autowireViaPrefixedMethods(object, services, cls, "inject");
    }

    private void autowireViaFields(Object object, List<Object> services, Class<?> cls) {
        List<Field> fields = Arrays.asList(cls.getDeclaredFields());
        Iterable injectFields = Iterables.filter(fields, (Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                Inject annotation = input.getAnnotation(Inject.class);
                return annotation != null;
            }
        });
        for (Field field : injectFields) {
            this.autowire(object, field, services);
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            this.autowireViaFields(object, services, superclass);
        }
    }

    private void autowire(Object object, Field field, List<Object> services) {
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            boolean canInject = this.isInjectorFieldFor(field, serviceClass);
            if (!canInject) continue;
            field.setAccessible(true);
            ServicesInjectorDefault.invokeInjectorField(field, object, service);
            return;
        }
    }

    private void autowireViaPrefixedMethods(Object object, List<Object> services, Class<?> cls, final String prefix) {
        List<Method> methods = Arrays.asList(cls.getMethods());
        Iterable prefixedMethods = Iterables.filter(methods, (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                String methodName = method.getName();
                return methodName.startsWith(prefix);
            }
        });
        for (Method prefixedMethod : prefixedMethods) {
            this.autowire(object, prefixedMethod, services);
        }
    }

    private void autowire(Object object, Method prefixedMethod, List<Object> services) {
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            boolean isInjectorMethod = this.injectorMethodEvaluator.isInjectorMethodFor(prefixedMethod, serviceClass);
            if (!isInjectorMethod) continue;
            prefixedMethod.setAccessible(true);
            ServicesInjectorDefault.invokeInjectorMethod(prefixedMethod, object, service);
            return;
        }
    }

    private boolean isInjectorFieldFor(Field field, Class<?> serviceClass) {
        Class<?> type = field.getType();
        return type != null && type.isAssignableFrom(serviceClass);
    }

    private static void invokeMethod(Method method, Object target, Object[] parameters) {
        try {
            method.invoke(target, parameters);
        }
        catch (SecurityException e) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (IllegalArgumentException e1) {
            throw new MetaModelException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new MetaModelException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new MetaModelException(targetException);
        }
    }

    private static void invokeInjectorField(Field field, Object target, Object parameter) {
        try {
            field.set(target, parameter);
        }
        catch (IllegalArgumentException e) {
            throw new MetaModelException(e);
        }
        catch (IllegalAccessException e) {
            throw new MetaModelException(String.format("Cannot access the %s field in %s", field.getName(), target.getClass().getName()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected " + parameter + " into " + new ToString(target));
        }
    }

    private static void invokeInjectorMethod(Method method, Object target, Object parameter) {
        Object[] parameters = new Object[]{parameter};
        ServicesInjectorDefault.invokeMethod(method, target, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug("injected " + parameter + " into " + new ToString(target));
        }
    }

    private void autowireServicesAndContainer() {
        this.injectServicesInto(this.services);
    }

    @Override
    public <T> T lookupService(Class<T> serviceClass) {
        List<T> services = this.lookupServices(serviceClass);
        return !services.isEmpty() ? (T)services.get(0) : null;
    }

    @Override
    public <T> List<T> lookupServices(Class<T> serviceClass) {
        this.locateAndCache(serviceClass);
        return this.servicesAssignableToType.get(serviceClass);
    }

    private void locateAndCache(Class<?> serviceClass) {
        if (this.servicesAssignableToType.containsKey(serviceClass)) {
            return;
        }
        ArrayList matchingServices = Lists.newArrayList();
        ServicesInjectorDefault.addAssignableTo(serviceClass, this.services, matchingServices);
        this.servicesAssignableToType.put(serviceClass, matchingServices);
    }

    private static void addAssignableTo(Class<?> type, List<Object> candidates, List<Object> filteredServicesAndContainer) {
        Iterable filteredServices = Iterables.filter(candidates, ServicesInjectorDefault.ofType(type));
        filteredServicesAndContainer.addAll(Lists.newArrayList((Iterable)filteredServices));
    }

    private static final Predicate<Object> ofType(final Class<?> cls) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return cls.isAssignableFrom(input.getClass());
            }
        };
    }

    @Override
    public void setSpecificationLoader(SpecificationLoader specificationLookup) {
        this.injectorMethodEvaluator = specificationLookup;
    }
}

