/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layout.memberorderfacet;

import java.util.Comparator;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.DeweyOrderSet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberIdentifierComparator;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderFacetComparator;
import org.apache.isis.core.metamodel.layout.memberorderfacet.OrderSetGroupNameComparator;

public class MemberOrderComparator
implements Comparator<Object> {
    private final MemberOrderFacetComparator memberOrderFacetComparator;
    private final MemberIdentifierComparator memberIdentifierComparator = new MemberIdentifierComparator();
    private final OrderSetGroupNameComparator orderSetComparator = new OrderSetGroupNameComparator(true);

    public MemberOrderComparator(boolean ensureGroupIsSame) {
        this.memberOrderFacetComparator = new MemberOrderFacetComparator(ensureGroupIsSame);
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof IdentifiedHolder && o2 instanceof IdentifiedHolder) {
            return this.compare((IdentifiedHolder)o1, (IdentifiedHolder)o2);
        }
        if (o1 instanceof DeweyOrderSet && o2 instanceof DeweyOrderSet) {
            return this.orderSetComparator.compare((DeweyOrderSet)o1, (DeweyOrderSet)o2);
        }
        if (o1 instanceof IdentifiedHolder && o2 instanceof DeweyOrderSet) {
            return -1;
        }
        if (o1 instanceof DeweyOrderSet && o2 instanceof IdentifiedHolder) {
            return 1;
        }
        throw new IllegalArgumentException("can only compare IdentifiedHolders and DeweyOrderSets");
    }

    @Override
    public int compare(IdentifiedHolder o1, IdentifiedHolder o2) {
        MemberOrderFacet m2;
        MemberOrderFacet m1 = this.getMemberOrder(o1);
        int memberOrderComparison = this.memberOrderFacetComparator.compare(m1, m2 = this.getMemberOrder(o2));
        if (memberOrderComparison != 0) {
            return memberOrderComparison;
        }
        return this.memberIdentifierComparator.compare(o1, o2);
    }

    private MemberOrderFacet getMemberOrder(FacetHolder facetHolder) {
        return facetHolder.getFacet(MemberOrderFacet.class);
    }
}

