/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.layout;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberIdentifierComparator;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderComparator;

public class DeweyOrderSet
implements Comparable<DeweyOrderSet>,
Iterable<Object> {
    private final List<Object> elements = Lists.newArrayList();
    private final String groupFullName;
    private final String groupName;
    private final String groupPath;
    private DeweyOrderSet parent;
    protected SortedSet<DeweyOrderSet> childOrderSets = new TreeSet<DeweyOrderSet>();

    public static DeweyOrderSet createOrderSet(List<? extends IdentifiedHolder> identifiedHolders) {
        TreeMap sortedMembersByGroup = Maps.newTreeMap();
        TreeSet nonAnnotatedGroup = Sets.newTreeSet((Comparator)new MemberIdentifierComparator());
        for (IdentifiedHolder identifiedHolder : identifiedHolders) {
            MemberOrderFacet memberOrder = identifiedHolder.getFacet(MemberOrderFacet.class);
            if (memberOrder == null) {
                nonAnnotatedGroup.add(identifiedHolder);
                continue;
            }
            SortedSet<IdentifiedHolder> sortedMembersForGroup = DeweyOrderSet.getSortedSet(sortedMembersByGroup, memberOrder.name());
            sortedMembersForGroup.add(identifiedHolder);
        }
        SortedSet<IdentifiedHolder> defaultSet = DeweyOrderSet.getSortedSet(sortedMembersByGroup, "");
        defaultSet.addAll(nonAnnotatedGroup);
        Set set = sortedMembersByGroup.keySet();
        TreeMap orderSetsByGroup = Maps.newTreeMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            String groupName = string = (String)iterator.next();
            DeweyOrderSet deweyOrderSet = new DeweyOrderSet(groupName);
            orderSetsByGroup.put(groupName, deweyOrderSet);
            DeweyOrderSet.ensureParentFor(orderSetsByGroup, deweyOrderSet);
        }
        for (String groupName : set) {
            DeweyOrderSet deweyOrderSet = (DeweyOrderSet)orderSetsByGroup.get(groupName);
            SortedSet sortedMembers = (SortedSet)sortedMembersByGroup.get(groupName);
            deweyOrderSet.addAll(sortedMembers);
            deweyOrderSet.copyOverChildren();
        }
        return (DeweyOrderSet)orderSetsByGroup.get("");
    }

    private static void ensureParentFor(SortedMap<String, DeweyOrderSet> orderSetsByGroup, DeweyOrderSet deweyOrderSet) {
        String parentGroup = deweyOrderSet.getGroupPath();
        DeweyOrderSet parentOrderSet = (DeweyOrderSet)orderSetsByGroup.get(parentGroup);
        if (parentOrderSet == null) {
            parentOrderSet = new DeweyOrderSet(parentGroup);
            orderSetsByGroup.put(parentGroup, parentOrderSet);
            if (!parentGroup.equals("")) {
                DeweyOrderSet.ensureParentFor(orderSetsByGroup, deweyOrderSet);
            }
        }
        if (deweyOrderSet != parentOrderSet) {
            deweyOrderSet.setParent(parentOrderSet);
            parentOrderSet.addChild(deweyOrderSet);
        }
    }

    private static SortedSet<IdentifiedHolder> getSortedSet(SortedMap<String, SortedSet<IdentifiedHolder>> sortedMembersByGroup, String groupName) {
        TreeSet<Object> sortedMembersForGroup = (TreeSet<Object>)sortedMembersByGroup.get(groupName);
        if (sortedMembersForGroup == null) {
            sortedMembersForGroup = new TreeSet<Object>(new MemberOrderComparator(true));
            sortedMembersByGroup.put(groupName, sortedMembersForGroup);
        }
        return sortedMembersForGroup;
    }

    private DeweyOrderSet(String groupFullName) {
        this.groupFullName = groupFullName;
        this.groupName = DeweyOrderSet.deriveGroupName(groupFullName);
        this.groupPath = DeweyOrderSet.deriveGroupPath(groupFullName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupFullName() {
        return this.groupFullName;
    }

    public String getGroupPath() {
        return this.groupPath;
    }

    private static String deriveGroupName(String groupFullName) {
        String groupSimpleName;
        StringTokenizer tokens = new StringTokenizer(groupFullName, ",", false);
        String[] groupNameComponents = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            groupNameComponents[i] = tokens.nextToken();
            ++i;
        }
        String string = groupSimpleName = groupNameComponents.length > 0 ? groupNameComponents[groupNameComponents.length - 1] : "";
        if (groupSimpleName.length() > 1) {
            return groupSimpleName.substring(0, 1).toUpperCase() + groupSimpleName.substring(1);
        }
        return groupSimpleName.toUpperCase();
    }

    private static String deriveGroupPath(String groupFullName) {
        int lastComma = groupFullName.lastIndexOf(",");
        if (lastComma == -1) {
            return "";
        }
        return groupFullName.substring(0, lastComma);
    }

    protected void setParent(DeweyOrderSet parent) {
        this.parent = parent;
    }

    public DeweyOrderSet getParent() {
        return this.parent;
    }

    protected void addChild(DeweyOrderSet childOrderSet) {
        this.childOrderSets.add(childOrderSet);
    }

    public List<DeweyOrderSet> children() {
        ArrayList<DeweyOrderSet> list = new ArrayList<DeweyOrderSet>();
        list.addAll(this.childOrderSets);
        return list;
    }

    protected void copyOverChildren() {
        this.addAll(this.childOrderSets);
    }

    public List<Object> elementList() {
        return new ArrayList<Object>(this.elements);
    }

    public int size() {
        return this.elements.size();
    }

    protected void addElement(Object element) {
        this.elements.add(element);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    protected void addAll(SortedSet<?> sortedMembers) {
        for (Object deweyOrderSet : sortedMembers) {
            this.addElement(deweyOrderSet);
        }
    }

    public void reorderChildren(List<String> requiredOrder) {
        DeweyOrderSet orderSet;
        LinkedHashMap orderSets = Maps.newLinkedHashMap();
        for (Object child : this.elementList()) {
            if (!(child instanceof DeweyOrderSet)) continue;
            orderSet = (DeweyOrderSet)child;
            this.elements.remove(orderSet);
            orderSets.put(orderSet.getGroupName(), orderSet);
        }
        for (String group : requiredOrder) {
            orderSet = (DeweyOrderSet)orderSets.get(group);
            if (orderSet == null) continue;
            orderSets.remove(group);
            this.elements.add(orderSet);
        }
        for (String orderSetGroupName : orderSets.keySet()) {
            orderSet = (DeweyOrderSet)orderSets.get(orderSetGroupName);
            this.elements.add(orderSet);
        }
    }

    @Override
    public int compareTo(DeweyOrderSet o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.groupFullName.compareTo(o.groupFullName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeweyOrderSet other = (DeweyOrderSet)obj;
        return !(this.groupFullName == null ? other.groupFullName != null : !this.groupFullName.equals(other.groupFullName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupFullName == null ? 0 : this.groupFullName.hashCode());
        return result;
    }

    public String toString() {
        return this.getGroupFullName() + ":" + this.size() + "el/" + (this.size() - this.childOrderSets.size()) + "m/" + this.childOrderSets.size() + "ch";
    }
}

