/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.timestamp;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.value.TimeStamp;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.value.ValueSemanticsProviderAbstractTemporal;

public abstract class TimeStampValueSemanticsProviderAbstract<T>
extends ValueSemanticsProviderAbstractTemporal<T> {
    private static final Object DEFAULT_VALUE = null;
    private static final int TYPICAL_LENGTH = 25;

    protected static void initFormats(Map<String, DateFormat> formats) {
        formats.put("iso_encoding", TimeStampValueSemanticsProviderAbstract.createDateEncodingFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("short", DateFormat.getDateTimeInstance(3, 1));
    }

    public TimeStampValueSemanticsProviderAbstract(FacetHolder holder, Class<T> adaptedClass, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super("timestamp", holder, adaptedClass, 25, ValueSemanticsProviderAndFacetAbstract.Immutability.NOT_IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, configuration, context);
        String formatRequired = configuration.getString("isis.value.format.timestamp");
        if (formatRequired == null) {
            this.format = this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    @Override
    protected T add(T original, int years, int months, int days, int hours, int minutes) {
        return original;
    }

    @Override
    protected Date dateValue(Object value) {
        return new Date(((TimeStamp)value).longValue());
    }

    @Override
    protected String defaultFormat() {
        return "short";
    }

    @Override
    public String toString() {
        return "TimeStampValueSemanticsProvider: " + this.format;
    }

    @Override
    protected DateFormat format(Localization localization) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, localization.getLocale());
        dateFormat.setTimeZone(localization.getTimeZone());
        return dateFormat;
    }

    @Override
    protected List<DateFormat> formatsToTry(Localization localization) {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        formats.add(DateFormat.getDateTimeInstance(2, 1, localization.getLocale()));
        formats.add(DateFormat.getDateTimeInstance(3, 1, localization.getLocale()));
        formats.add(TimeStampValueSemanticsProviderAbstract.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        for (DateFormat format : formats) {
            format.setTimeZone(localization.getTimeZone());
        }
        return formats;
    }
}

