/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejoda;

import java.util.Date;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.value.datetimejoda.JodaDateTimeValueSemanticsProviderAbstract;
import org.joda.time.DateTime;

public class JodaDateTimeValueSemanticsProvider
extends JodaDateTimeValueSemanticsProviderAbstract<DateTime> {
    private static final DateTime DEFAULT_VALUE = null;

    public JodaDateTimeValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public JodaDateTimeValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(holder, DateTime.class, DEFAULT_VALUE, configuration, context);
    }

    @Override
    protected DateTime add(DateTime original, int years, int months, int days, int hours, int minutes) {
        if (hours != 0 || minutes != 0) {
            throw new IllegalArgumentException("cannot add non-zero hours or minutes to a DateTime");
        }
        return original.plusYears(years).plusMonths(months).plusDays(days);
    }

    @Override
    protected DateTime now() {
        return new DateTime();
    }

    @Override
    protected Date dateValue(Object value) {
        return ((DateTime)value).toDateTime().toDate();
    }

    @Override
    protected DateTime setDate(Date date) {
        return new DateTime(date.getTime());
    }
}

