/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.chars;

import java.text.DecimalFormat;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.InvalidEntryException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.value.chars.CharValueFacet;

public abstract class CharValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Character>
implements CharValueFacet {
    private static final Character DEFAULT_VALUE = Character.valueOf('\u0000');
    private static final int MAX_LENGTH = 1;
    private static final int TYPICAL_LENGTH = 1;

    private static Class<? extends Facet> type() {
        return CharValueFacet.class;
    }

    public CharValueSemanticsProviderAbstract(FacetHolder holder, Class<Character> adaptedClass, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(CharValueSemanticsProviderAbstract.type(), holder, adaptedClass, 1, 1, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, configuration, context);
    }

    @Override
    public Character doParse(Object context, String entry) {
        if (entry.length() > 1) {
            throw new InvalidEntryException("Only a single character is required");
        }
        return Character.valueOf(entry.charAt(0));
    }

    @Override
    public String titleString(Object value, Localization localization) {
        return value == null ? "" : value.toString();
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Character doRestore(String data) {
        return Character.valueOf(data.charAt(0));
    }

    @Override
    public Character charValue(ObjectAdapter object) {
        return object == null ? null : (Character)object.getObject();
    }

    @Override
    public ObjectAdapter createValue(Character value) {
        return this.getAdapterManager().adapterFor(value);
    }

    @Override
    public String toString() {
        return "CharacterValueSemanticsProvider";
    }
}

