/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.booleans;

import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.value.booleans.BooleanValueFacet;

public abstract class BooleanValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Boolean>
implements BooleanValueFacet {
    private static final int MAX_LENGTH = 5;
    private static final int TYPICAL_LENGTH = 5;

    private static Class<? extends Facet> type() {
        return BooleanValueFacet.class;
    }

    public BooleanValueSemanticsProviderAbstract(FacetHolder holder, Class<Boolean> adaptedClass, Boolean defaultValue, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(BooleanValueSemanticsProviderAbstract.type(), holder, adaptedClass, 5, 5, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, defaultValue, configuration, context);
    }

    @Override
    protected Boolean doParse(Object context, String entry) {
        String compareTo = entry.trim().toLowerCase();
        if ("true".equals(compareTo)) {
            return Boolean.TRUE;
        }
        if ("false".startsWith(compareTo)) {
            return Boolean.FALSE;
        }
        throw new TextEntryParseException(String.format("'%s' cannot be parsed as a boolean", entry));
    }

    @Override
    public String titleString(Object value, Localization localization) {
        return value == null ? "" : (this.isSet(value) ? "True" : "False");
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(value, null);
    }

    @Override
    protected String doEncode(Object object) {
        return this.isSet(object) ? "T" : "F";
    }

    @Override
    protected Boolean doRestore(String data) {
        int dataLength = data.length();
        if (dataLength == 1) {
            switch (data.charAt(0)) {
                case 'T': {
                    return Boolean.TRUE;
                }
                case 'F': {
                    return Boolean.FALSE;
                }
            }
            throw new IsisException("Invalid data for logical, expected 'T', 'F' or 'N, but got " + data.charAt(0));
        }
        if (dataLength == 4 || dataLength == 5) {
            switch (data.charAt(0)) {
                case 't': {
                    return Boolean.TRUE;
                }
                case 'f': {
                    return Boolean.FALSE;
                }
            }
            throw new IsisException("Invalid data for logical, expected 't' or 'f', but got " + data.charAt(0));
        }
        throw new IsisException("Invalid data for logical, expected 1, 4 or 5 bytes, got " + dataLength + ": " + data);
    }

    private boolean isSet(Object value) {
        return (Boolean)value;
    }

    @Override
    public boolean isSet(ObjectAdapter adapter) {
        if (!ObjectAdapter.Util.exists(adapter)) {
            return false;
        }
        Object object = adapter.getObject();
        Boolean objectAsBoolean = (Boolean)object;
        return objectAsBoolean;
    }

    @Override
    public String toString() {
        return "BooleanValueSemanticsProvider";
    }
}

