/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.blobs;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderContext;
import org.apache.isis.core.metamodel.facets.value.blobs.BlobValueFacet;

public class BlobValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<Blob>
implements BlobValueFacet {
    private static final int TYPICAL_LENGTH = 0;
    private static final Blob DEFAULT_VALUE = null;

    private static Class<? extends Facet> type() {
        return BlobValueFacet.class;
    }

    public BlobValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public BlobValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(BlobValueSemanticsProvider.type(), holder, Blob.class, 0, null, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, configuration, context);
    }

    @Override
    public String titleString(Object object, Localization localization) {
        return object != null ? ((Blob)object).getName() : "[null]";
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(value, null);
    }

    @Override
    public Parser<Blob> getParser() {
        return null;
    }

    @Override
    public DefaultsProvider<Blob> getDefaultsProvider() {
        return null;
    }

    @Override
    protected String doEncode(Object object) {
        Blob blob = (Blob)object;
        return blob.getName() + ":" + blob.getMimeType().getBaseType() + ":" + Base64.encodeBase64String((byte[])blob.getBytes());
    }

    @Override
    protected Blob doRestore(String data) {
        int colonIdx = data.indexOf(58);
        String name = data.substring(0, colonIdx);
        int colon2Idx = data.indexOf(":", colonIdx + 1);
        String mimeTypeBase = data.substring(colonIdx + 1, colon2Idx);
        byte[] bytes = Base64.decodeBase64((String)data.substring(colon2Idx + 1));
        try {
            return new Blob(name, new MimeType(mimeTypeBase), bytes);
        }
        catch (MimeTypeParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "BlobValueSemanticsProvider";
    }
}

