/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.typicallen.annotation;

import java.util.Properties;
import org.apache.isis.applib.annotation.TypicalLength;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.typicallen.annotation.TypicalLengthFacetOnPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.typicallen.annotation.TypicalLengthFacetOnPropertyFromProperties;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class TypicalLengthOnPropertyFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
MetaModelValidatorRefiner,
IsisConfigurationAware {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(TypicalLength.class);

    public TypicalLengthOnPropertyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        TypicalLengthFacet facet = TypicalLengthOnPropertyFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (facet == null) {
            facet = this.validator.flagIfPresent(TypicalLengthOnPropertyFacetFactory.createFromAnnotationIfPossible(processMethodContext), processMethodContext);
        }
        FacetUtil.addFacet(facet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        TypicalLengthFacet facet = TypicalLengthOnPropertyFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(facet);
    }

    private static TypicalLengthFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("typicalLength");
        return properties != null ? new TypicalLengthFacetOnPropertyFromProperties(properties, holder) : null;
    }

    private static TypicalLengthFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        TypicalLength annotation = Annotations.getAnnotation(processMethodContext.getMethod(), TypicalLength.class);
        return annotation != null ? new TypicalLengthFacetOnPropertyAnnotation(annotation.value(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.validator.setConfiguration(configuration);
    }
}

