/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.propertylayout;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.CssClassFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.CssClassFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.DescribedAsFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.DescribedAsFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.HiddenFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.HiddenFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.LabelAtFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.LabelAtFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.MultiLineFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.MultiLineFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.NamedFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.NamedFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.RenderedAdjustedFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.RenderedAdjustedFacetOnPropertyFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.TypicalLengthFacetForPropertyLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.properties.propertylayout.TypicalLengthFacetOnPropertyFromLayoutProperties;

public class PropertyLayoutFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public PropertyLayoutFacetFactory() {
        super(FeatureType.PROPERTIES_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Object holder = processMethodContext.getFacetHolder();
        Method method = processMethodContext.getMethod();
        Properties properties = processMethodContext.metadataProperties("propertyLayout");
        if (properties == null) {
            properties = processMethodContext.metadataProperties("layout");
        }
        PropertyLayout propertyLayout = Annotations.getAnnotation(method, PropertyLayout.class);
        CssClassFacet cssClassFacet = CssClassFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (cssClassFacet == null) {
            cssClassFacet = CssClassFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(cssClassFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (describedAsFacet == null) {
            describedAsFacet = DescribedAsFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (hiddenFacet == null) {
            hiddenFacet = HiddenFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(hiddenFacet);
        LabelAtFacet labelAtFacet = LabelAtFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (labelAtFacet == null) {
            labelAtFacet = LabelAtFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(labelAtFacet);
        MultiLineFacet multiLineFacet = MultiLineFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (multiLineFacet == null) {
            multiLineFacet = MultiLineFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(multiLineFacet);
        NamedFacet namedFacet = NamedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (namedFacet == null) {
            namedFacet = NamedFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(namedFacet);
        RenderedAdjustedFacet renderedAdjustedFacet = RenderedAdjustedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (renderedAdjustedFacet == null) {
            renderedAdjustedFacet = RenderedAdjustedFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(renderedAdjustedFacet);
        TypicalLengthFacet typicalLengthFacet = TypicalLengthFacetOnPropertyFromLayoutProperties.create(properties, holder);
        if (typicalLengthFacet == null) {
            typicalLengthFacet = TypicalLengthFacetForPropertyLayoutAnnotation.create(propertyLayout, holder);
        }
        FacetUtil.addFacet(typicalLengthFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Object holder = processMemberContext.getFacetHolder();
        Properties properties = processMemberContext.metadataProperties("propertyLayout");
        if (properties == null) {
            properties = processMemberContext.metadataProperties("layout");
        }
        CssClassFacet cssClassFacet = CssClassFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(cssClassFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(hiddenFacet);
        LabelAtFacet labelAtFacet = LabelAtFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(labelAtFacet);
        MultiLineFacet multiLineFacet = MultiLineFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(multiLineFacet);
        NamedFacet namedFacet = NamedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(namedFacet);
        RenderedAdjustedFacet renderedAdjustedFacet = RenderedAdjustedFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(renderedAdjustedFacet);
        TypicalLengthFacet typicalLengthFacet = TypicalLengthFacetOnPropertyFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(typicalLengthFacet);
    }
}

