/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.modify;

import org.apache.isis.applib.events.UsabilityEvent;
import org.apache.isis.applib.events.ValidityEvent;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.PropertyDomainEvent;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacet;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;

public abstract class PropertyDomainEventFacetAbstract
extends SingleClassValueFacetAbstract
implements PropertyDomainEventFacet {
    private final DomainEventHelper domainEventHelper;
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final TranslationService translationService;
    private final String translationContext;

    public PropertyDomainEventFacetAbstract(Class<? extends PropertyDomainEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, FacetHolder holder, ServicesInjector servicesInjector, SpecificationLoader specificationLoader) {
        super(PropertyDomainEventFacet.class, holder, eventType, specificationLoader);
        this.getterFacet = getterFacet;
        this.translationService = servicesInjector.lookupService(TranslationService.class);
        this.translationContext = ((IdentifiedHolder)holder).getIdentifier().toClassAndNameIdentityString();
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        if (!this.domainEventHelper.hasEventBusService()) {
            return null;
        }
        PropertyDomainEvent<?, ?> event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.HIDE, this.eventType(), null, this.getIdentified(), ic.getTarget(), null, null);
        if (event != null && event.isHidden()) {
            return "Hidden by subscriber";
        }
        return null;
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        if (!this.domainEventHelper.hasEventBusService()) {
            return null;
        }
        PropertyDomainEvent<?, ?> event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.DISABLE, this.eventType(), null, this.getIdentified(), ic.getTarget(), null, null);
        if (event != null && event.isDisabled()) {
            TranslatableString reasonTranslatable = event.getDisabledReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getDisabledReason();
        }
        return null;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> ic) {
        if (!this.domainEventHelper.hasEventBusService()) {
            return null;
        }
        Object oldValue = this.getterFacet.getProperty(ic.getTarget(), ic.getSession(), ic.getDeploymentCategory());
        Object proposedValue = PropertyDomainEventFacetAbstract.proposedFrom(ic);
        PropertyDomainEvent<?, ?> event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.VALIDATE, this.eventType(), null, this.getIdentified(), ic.getTarget(), oldValue, proposedValue);
        if (event != null && event.isInvalid()) {
            TranslatableString reasonTranslatable = event.getInvalidityReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getInvalidityReason();
        }
        return null;
    }

    private static Object proposedFrom(ValidityContext<? extends ValidityEvent> ic) {
        ProposedHolder ph = (ProposedHolder)((Object)ic);
        ObjectAdapter proposedAdapter = ph.getProposed();
        return proposedAdapter != null ? proposedAdapter.getObject() : null;
    }

    private Class<?> eventType() {
        return this.value();
    }

    public Class<? extends PropertyDomainEvent<?, ?>> getEventType() {
        Class<?> eventType = this.eventType();
        return eventType;
    }
}

