/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.modify;

import com.google.common.base.Objects;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.PropertyDomainEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public abstract class PropertyClearFacetForDomainEventAbstract
extends SingleValueFacetAbstract<Class<? extends PropertyDomainEvent<?, ?>>>
implements PropertyClearFacet {
    private final DomainEventHelper domainEventHelper;
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final PropertyClearFacet clearFacet;
    private final PropertyDomainEventFacetAbstract propertyDomainEventFacet;

    public static Class<? extends Facet> type() {
        return PropertyClearFacet.class;
    }

    public PropertyClearFacetForDomainEventAbstract(Class<? extends PropertyDomainEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, PropertyClearFacet clearFacet, PropertyDomainEventFacetAbstract propertyDomainEventFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(PropertyClearFacetForDomainEventAbstract.type(), eventType, holder);
        this.getterFacet = getterFacet;
        this.clearFacet = clearFacet;
        this.propertyDomainEventFacet = propertyDomainEventFacet;
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public void clearProperty(ObjectAdapter targetAdapter) {
        if (this.clearFacet == null) {
            return;
        }
        if (!this.domainEventHelper.hasEventBusService()) {
            this.clearFacet.clearProperty(targetAdapter);
            return;
        }
        Object oldValue = this.getterFacet.getProperty(targetAdapter, null, null);
        PropertyDomainEvent<?, ?> event = this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.EXECUTING, this.eventType(), null, this.getIdentified(), targetAdapter, oldValue, null);
        this.clearFacet.clearProperty(targetAdapter);
        Object actualNewValue = this.getterFacet.getProperty(targetAdapter, null, null);
        if (Objects.equal((Object)oldValue, (Object)actualNewValue)) {
            return;
        }
        this.domainEventHelper.postEventForProperty(AbstractDomainEvent.Phase.EXECUTED, this.eventType(), this.verify(event), this.getIdentified(), targetAdapter, oldValue, actualNewValue);
    }

    protected PropertyDomainEvent<?, ?> verify(PropertyDomainEvent<?, ?> event) {
        return event;
    }

    private Class<? extends PropertyDomainEvent<?, ?>> eventType() {
        return (Class)this.value();
    }
}

