/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property;

import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.Disabled;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.annotation.Mandatory;
import org.apache.isis.applib.annotation.MaxLength;
import org.apache.isis.applib.annotation.MustSatisfy;
import org.apache.isis.applib.annotation.NotPersisted;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.annotation.PostsPropertyChangedEvent;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyInteraction;
import org.apache.isis.applib.annotation.RegEx;
import org.apache.isis.applib.services.eventbus.PropertyDomainEvent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.TitleFacetFormattedByRegex;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacet;
import org.apache.isis.core.metamodel.facets.properties.property.disabled.DisabledFacetForDisabledAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.disabled.DisabledFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.hidden.HiddenFacetForHiddenAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.hidden.HiddenFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.mandatory.MandatoryFacetForMandatoryAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.mandatory.MandatoryFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.mandatory.MandatoryFacetInvertedByOptionalAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.maxlength.MaxLengthFacetForMaxLengthAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.maxlength.MaxLengthFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyClearFacetForDomainEventAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyClearFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyClearFacetForDomainEventFromPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyClearFacetForDomainEventFromPropertyInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyClearFacetForPostsPropertyChangedEventAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetDefault;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetForPropertyInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterFacetForDomainEventAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterFacetForDomainEventFromPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterFacetForDomainEventFromPropertyInteractionAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterFacetForPostsPropertyChangedEventAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.mustsatisfy.MustSatisfySpecificationFacetForMustSatisfyAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.mustsatisfy.MustSatisfySpecificationFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.notpersisted.NotPersistedFacetForNotPersistedAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.notpersisted.NotPersistedFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.regex.RegExFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.regex.RegExFacetForRegExAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class PropertyAnnotationFacetFactory
extends FacetFactoryAbstract
implements ServicesInjectorAware,
MetaModelValidatorRefiner,
IsisConfigurationAware {
    private final MetaModelValidatorForDeprecatedAnnotation postsPropertyChangedEventValidator = new MetaModelValidatorForDeprecatedAnnotation(PostsPropertyChangedEvent.class);
    private final MetaModelValidatorForDeprecatedAnnotation propertyInteractionValidator = new MetaModelValidatorForDeprecatedAnnotation(PropertyInteraction.class);
    private final MetaModelValidatorForDeprecatedAnnotation regexValidator = new MetaModelValidatorForDeprecatedAnnotation(RegEx.class);
    private final MetaModelValidatorForDeprecatedAnnotation optionalValidator = new MetaModelValidatorForDeprecatedAnnotation(Optional.class);
    private final MetaModelValidatorForDeprecatedAnnotation mandatoryValidator = new MetaModelValidatorForDeprecatedAnnotation(Mandatory.class);
    private final MetaModelValidatorForDeprecatedAnnotation hiddenValidator = new MetaModelValidatorForDeprecatedAnnotation(Hidden.class);
    private final MetaModelValidatorForDeprecatedAnnotation disabledValidator = new MetaModelValidatorForDeprecatedAnnotation(Disabled.class);
    private final MetaModelValidatorForDeprecatedAnnotation maxLengthValidator = new MetaModelValidatorForDeprecatedAnnotation(MaxLength.class);
    private final MetaModelValidatorForDeprecatedAnnotation mustSatisfyValidator = new MetaModelValidatorForDeprecatedAnnotation(MustSatisfy.class);
    private final MetaModelValidatorForDeprecatedAnnotation notPersistedValidator = new MetaModelValidatorForDeprecatedAnnotation(NotPersisted.class);
    private ServicesInjector servicesInjector;

    public PropertyAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.processModify(processMethodContext);
        this.processHidden(processMethodContext);
        this.processEditing(processMethodContext);
        this.processMaxLength(processMethodContext);
        this.processMustSatisfy(processMethodContext);
        this.processNotPersisted(processMethodContext);
        this.processOptional(processMethodContext);
        this.processRegEx(processMethodContext);
    }

    void processModify(FacetFactory.ProcessMethodContext processMethodContext) {
        PropertyClearFacet clearFacet;
        PropertyDomainEventFacetAbstract propertyDomainEventFacet;
        Class propertyDomainEventType;
        Method method = processMethodContext.getMethod();
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        PropertyOrCollectionAccessorFacet getterFacet = holder.getFacet(PropertyOrCollectionAccessorFacet.class);
        if (getterFacet == null) {
            return;
        }
        PostsPropertyChangedEvent postsPropertyChangedEvent = Annotations.getAnnotation(method, PostsPropertyChangedEvent.class);
        PropertyInteraction propertyInteraction = Annotations.getAnnotation(method, PropertyInteraction.class);
        Property property = Annotations.getAnnotation(method, Property.class);
        if (propertyInteraction != null) {
            propertyDomainEventType = propertyInteraction.value();
            propertyDomainEventFacet = this.propertyInteractionValidator.flagIfPresent(new PropertyDomainEventFacetForPropertyInteractionAnnotation(propertyDomainEventType, getterFacet, this.servicesInjector, this.getSpecificationLoader(), holder), processMethodContext);
        } else if (property != null && property.domainEvent() != null) {
            propertyDomainEventType = property.domainEvent();
            propertyDomainEventFacet = new PropertyDomainEventFacetForPropertyAnnotation(propertyDomainEventType, getterFacet, this.servicesInjector, this.getSpecificationLoader(), holder);
        } else {
            propertyDomainEventType = PropertyDomainEvent.Default.class;
            propertyDomainEventFacet = new PropertyDomainEventFacetDefault(propertyDomainEventType, getterFacet, this.servicesInjector, this.getSpecificationLoader(), holder);
        }
        FacetUtil.addFacet(propertyDomainEventFacet);
        PropertySetterFacet setterFacet = holder.getFacet(PropertySetterFacet.class);
        if (setterFacet != null) {
            PropertySetterFacetForDomainEventAbstract replacementFacet;
            if (postsPropertyChangedEvent != null) {
                Class propertySetEventType = postsPropertyChangedEvent.value();
                replacementFacet = new PropertySetterFacetForPostsPropertyChangedEventAnnotation(propertySetEventType, getterFacet, setterFacet, propertyDomainEventFacet, holder, this.servicesInjector);
            } else {
                replacementFacet = propertyInteraction != null ? new PropertySetterFacetForDomainEventFromPropertyInteractionAnnotation(propertyDomainEventType, getterFacet, setterFacet, propertyDomainEventFacet, holder, this.servicesInjector) : (property != null ? new PropertySetterFacetForDomainEventFromPropertyAnnotation(propertyDomainEventType, getterFacet, setterFacet, propertyDomainEventFacet, holder, this.servicesInjector) : new PropertySetterFacetForDomainEventFromDefault(propertyDomainEventType, getterFacet, setterFacet, propertyDomainEventFacet, holder, this.servicesInjector));
            }
            FacetUtil.addFacet(replacementFacet);
        }
        if ((clearFacet = holder.getFacet(PropertyClearFacet.class)) != null) {
            PropertyClearFacetForDomainEventAbstract replacementFacet;
            if (postsPropertyChangedEvent != null) {
                Class propertyClearEventType = postsPropertyChangedEvent.value();
                replacementFacet = new PropertyClearFacetForPostsPropertyChangedEventAnnotation(propertyClearEventType, getterFacet, clearFacet, propertyDomainEventFacet, holder, this.servicesInjector);
            } else {
                replacementFacet = propertyInteraction != null ? new PropertyClearFacetForDomainEventFromPropertyInteractionAnnotation(propertyDomainEventType, getterFacet, clearFacet, propertyDomainEventFacet, holder, this.servicesInjector) : (property != null ? new PropertyClearFacetForDomainEventFromPropertyAnnotation(propertyDomainEventType, getterFacet, clearFacet, propertyDomainEventFacet, holder, this.servicesInjector) : new PropertyClearFacetForDomainEventFromDefault(propertyDomainEventType, getterFacet, clearFacet, propertyDomainEventFacet, holder, this.servicesInjector));
            }
            FacetUtil.addFacet(replacementFacet);
        }
    }

    void processHidden(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Hidden hiddenAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Hidden.class);
        HiddenFacet facet = this.hiddenValidator.flagIfPresent(HiddenFacetForHiddenAnnotationOnProperty.create(hiddenAnnotation, holder), processMethodContext);
        Property property = Annotations.getAnnotation(method, Property.class);
        if (facet == null) {
            facet = HiddenFacetForPropertyAnnotation.create(property, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processEditing(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Disabled annotation = Annotations.getAnnotation(method, Disabled.class);
        DisabledFacet disabledFacet = DisabledFacetForDisabledAnnotationOnProperty.create(annotation, holder);
        DisabledFacet facet = this.disabledValidator.flagIfPresent(disabledFacet, processMethodContext);
        Property property = Annotations.getAnnotation(method, Property.class);
        if (facet == null) {
            facet = DisabledFacetForPropertyAnnotation.create(property, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processMaxLength(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        MaxLength annotation = Annotations.getAnnotation(method, MaxLength.class);
        MaxLengthFacet facet = this.maxLengthValidator.flagIfPresent(MaxLengthFacetForMaxLengthAnnotationOnProperty.create(annotation, holder), processMethodContext);
        Property property = Annotations.getAnnotation(method, Property.class);
        if (facet == null) {
            facet = MaxLengthFacetForPropertyAnnotation.create(property, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processMustSatisfy(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        MustSatisfy annotation = Annotations.getAnnotation(method, MustSatisfy.class);
        Facet facet = this.mustSatisfyValidator.flagIfPresent(MustSatisfySpecificationFacetForMustSatisfyAnnotationOnProperty.create(annotation, holder, this.servicesInjector), processMethodContext);
        Property property = Annotations.getAnnotation(method, Property.class);
        if (facet == null) {
            facet = MustSatisfySpecificationFacetForPropertyAnnotation.create(property, holder, this.servicesInjector);
        }
        FacetUtil.addFacet(facet);
    }

    void processNotPersisted(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        NotPersisted annotation = Annotations.getAnnotation(method, NotPersisted.class);
        NotPersistedFacet facet = this.notPersistedValidator.flagIfPresent(NotPersistedFacetForNotPersistedAnnotationOnProperty.create(annotation, holder), processMethodContext);
        Property property = Annotations.getAnnotation(method, Property.class);
        if (facet == null) {
            facet = NotPersistedFacetForPropertyAnnotation.create(property, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processOptional(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Optional optionalAnnotation = Annotations.getAnnotation(method, Optional.class);
        MandatoryFacet facet = this.optionalValidator.flagIfPresent(MandatoryFacetInvertedByOptionalAnnotationOnProperty.create(optionalAnnotation, method, holder), processMethodContext);
        Mandatory mandatoryAnnotation = Annotations.getAnnotation(method, Mandatory.class);
        if (facet == null) {
            facet = this.mandatoryValidator.flagIfPresent(MandatoryFacetForMandatoryAnnotationOnProperty.create(mandatoryAnnotation, holder), processMethodContext);
        }
        Property property = Annotations.getAnnotation(method, Property.class);
        if (facet == null) {
            facet = MandatoryFacetForPropertyAnnotation.create(property, method, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processRegEx(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        RegEx annotation = Annotations.getAnnotation(processMethodContext.getMethod(), RegEx.class);
        RegExFacet facet = this.regexValidator.flagIfPresent(RegExFacetForRegExAnnotationOnProperty.create(annotation, returnType, holder), processMethodContext);
        if (facet != null) {
            FacetUtil.addFacet(new TitleFacetFormattedByRegex(facet));
        }
        Property property = Annotations.getAnnotation(method, Property.class);
        if (facet == null) {
            facet = RegExFacetForPropertyAnnotation.create(property, returnType, holder);
        }
        FacetUtil.addFacet(facet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.postsPropertyChangedEventValidator);
        metaModelValidator.add(this.propertyInteractionValidator);
        metaModelValidator.add(this.regexValidator);
        metaModelValidator.add(this.optionalValidator);
        metaModelValidator.add(this.mandatoryValidator);
        metaModelValidator.add(this.hiddenValidator);
        metaModelValidator.add(this.disabledValidator);
        metaModelValidator.add(this.maxLengthValidator);
        metaModelValidator.add(this.mustSatisfyValidator);
        metaModelValidator.add(this.notPersistedValidator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.postsPropertyChangedEventValidator.setConfiguration(configuration);
        this.propertyInteractionValidator.setConfiguration(configuration);
        this.regexValidator.setConfiguration(configuration);
        this.optionalValidator.setConfiguration(configuration);
        this.mandatoryValidator.setConfiguration(configuration);
        this.hiddenValidator.setConfiguration(configuration);
        this.disabledValidator.setConfiguration(configuration);
        this.maxLengthValidator.setConfiguration(configuration);
        this.mustSatisfyValidator.setConfiguration(configuration);
        this.notPersistedValidator.setConfiguration(configuration);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

