/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.parameter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.MaxLength;
import org.apache.isis.applib.annotation.MustSatisfy;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.RegEx;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.TitleFacetFormattedByRegex;
import org.apache.isis.core.metamodel.facets.param.parameter.mandatory.MandatoryFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mandatory.MandatoryFacetInvertedByOptionalAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.maxlen.MaxLengthFacetForMaxLengthAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.maxlen.MaxLengthFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mustsatisfy.MustSatisfySpecificationFacetForMustSatisfyAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.mustsatisfy.MustSatisfySpecificationFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.regex.RegExFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.regex.RegExFacetFromRegExAnnotationOnParameter;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class ParameterAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
IsisConfigurationAware,
ServicesInjectorAware {
    private final MetaModelValidatorForDeprecatedAnnotation maxLengthValidator = new MetaModelValidatorForDeprecatedAnnotation(MaxLength.class);
    private final MetaModelValidatorForDeprecatedAnnotation mustSatisfyValidator = new MetaModelValidatorForDeprecatedAnnotation(MustSatisfy.class);
    private final MetaModelValidatorForDeprecatedAnnotation regexValidator = new MetaModelValidatorForDeprecatedAnnotation(RegEx.class);
    private final MetaModelValidatorForDeprecatedAnnotation optionalValidator = new MetaModelValidatorForDeprecatedAnnotation(Optional.class);
    private ServicesInjector servicesInjector;

    public ParameterAnnotationFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Class<?>[] parameterTypes;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        if (paramNum >= (parameterTypes = method.getParameterTypes()).length) {
            return;
        }
        this.processParamsMaxLength(processParameterContext);
        this.processParamsMustSatisfy(processParameterContext);
        this.processParamsRegEx(processParameterContext);
        this.processParamsOptional(processParameterContext);
    }

    void processParamsMaxLength(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            if (!(parameterAnnotation instanceof MaxLength)) continue;
            MaxLength annotation = (MaxLength)parameterAnnotation;
            MaxLengthFacet facet = MaxLengthFacetForMaxLengthAnnotationOnParameter.create(annotation, processParameterContext.getFacetHolder());
            FacetUtil.addFacet(this.maxLengthValidator.flagIfPresent(facet, processParameterContext));
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            FacetUtil.addFacet(MaxLengthFacetForParameterAnnotation.create(parameter, holder));
            return;
        }
    }

    void processParamsMustSatisfy(FacetFactory.ProcessParameterContext processParameterContext) {
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[] parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum];
        boolean mustSatisfyAnnotationFound = false;
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof MustSatisfy)) continue;
            MustSatisfy annotation = (MustSatisfy)parameterAnnotation;
            Facet facet = MustSatisfySpecificationFacetForMustSatisfyAnnotationOnParameter.create(annotation, processParameterContext.getFacetHolder(), this.servicesInjector);
            FacetUtil.addFacet(this.mustSatisfyValidator.flagIfPresent(facet, processParameterContext));
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            FacetUtil.addFacet(MustSatisfySpecificationFacetForParameterAnnotation.create(parameter, holder, this.servicesInjector));
            return;
        }
    }

    void processParamsRegEx(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            Class<?> parameterType = parameterTypes[paramNum];
            if (!(parameterAnnotation instanceof RegEx)) continue;
            RegEx annotation = (RegEx)parameterAnnotation;
            RegExFacet facet = RegExFacetFromRegExAnnotationOnParameter.create(annotation, parameterType, holder);
            FacetUtil.addFacet(this.regexValidator.flagIfPresent(facet, processParameterContext));
            RegExFacet regExFacet = facet;
            if (regExFacet != null) {
                FacetUtil.addFacet(new TitleFacetFormattedByRegex(regExFacet));
            }
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            Class<?> parameterType = parameterTypes[paramNum];
            FacetUtil.addFacet(RegExFacetForParameterAnnotation.create(parameter, parameterType, holder));
            return;
        }
    }

    void processParamsOptional(FacetFactory.ProcessParameterContext processParameterContext) {
        Annotation[] parameterAnnotations;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Annotation parameterAnnotation : parameterAnnotations = Annotations.getParameterAnnotations(method)[paramNum]) {
            Class<?> parameterType = parameterTypes[paramNum];
            if (!(parameterAnnotation instanceof Optional)) continue;
            Optional annotation = (Optional)parameterAnnotation;
            Facet facet = MandatoryFacetInvertedByOptionalAnnotationOnParameter.create(annotation, parameterType, holder);
            FacetUtil.addFacet(this.optionalValidator.flagIfPresent(facet, processParameterContext));
            return;
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof Parameter)) continue;
            Parameter parameter = (Parameter)parameterAnnotation;
            Class<?> parameterType = parameterTypes[paramNum];
            FacetUtil.addFacet(MandatoryFacetForParameterAnnotation.create(parameter, parameterType, holder));
            return;
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.maxLengthValidator);
        metaModelValidator.add(this.mustSatisfyValidator);
        metaModelValidator.add(this.regexValidator);
        metaModelValidator.add(this.optionalValidator);
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.maxLengthValidator.setConfiguration(configuration);
        this.mustSatisfyValidator.setConfiguration(configuration);
        this.regexValidator.setConfiguration(configuration);
        this.optionalValidator.setConfiguration(configuration);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

